package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CorrelationInformation;
import com.zzsn.leaderbase.mapper.CharacterDetailsMapper;
import com.zzsn.leaderbase.service.CharacterDetailsService;
import com.zzsn.leaderbase.util.EsUtil;
import com.zzsn.leaderbase.vo.DetailsListVo;
import com.zzsn.leaderbase.vo.Result;
import com.zzsn.leaderbase.vo.SubjectInfoVo;
import com.zzsn.leaderbase.vo.UserServerCharacterVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/4 16:28
 * @Content:
 */
@Service
public class CharacterDetailsServiceImpl extends ServiceImpl<CharacterDetailsMapper, CorrelationInformation> implements CharacterDetailsService {

    @Autowired
    CharacterDetailsMapper characterDetailsMapper;

    @Override
    public Result<?> informationList(DetailsListVo detailsListVo) {

        String uid = detailsListVo.getUid();
        Long type = detailsListVo.getType();

        LambdaQueryWrapper<CorrelationInformation> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(CorrelationInformation::getUid, uid);
        lambdaQuery.eq(CorrelationInformation::getType, type);
        lambdaQuery.orderByDesc(CorrelationInformation::getArticlePublishDate);

        StringBuffer sb = new StringBuffer()
                .append(" limit ")
                .append(detailsListVo.getOffset())
                .append(",")
                .append(detailsListVo.getPageSize());
        lambdaQuery.last(sb.toString());

        List<CorrelationInformation> list = characterDetailsMapper.selectList(lambdaQuery);

        IPage page = new Page();
        page.setRecords(list);

        Integer total = characterDetailsMapper.selectCount(lambdaQuery);
        page.setTotal(total);
        page.setCurrent(detailsListVo.getPageNo());
        page.setSize(detailsListVo.getPageSize());

        return Result.OK(page);
    }

}
