package com.zzsn.leaderbase.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.leaderbase.entity.CharacterExtractInfo;
import com.zzsn.leaderbase.vo.ExtractListVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface CharacterExtractInfoMapper extends BaseMapper<CharacterExtractInfo> {

    @Select("select count(1) " +
            "from character_extract_info a " +
            "where 1=1 " +
            "and a.duty = #{duty} " +
            "and a.department = #{department} " +
            "and a.name = #{name}"
    )
    Integer deduplication(String duty, String department, String name);

    List<CharacterExtractInfo> getList(ExtractListVo extractListVo);

    Integer getListCount(ExtractListVo extractListVo);

    String getOriginBySid(@Param("sid") String sid);
}
