package com.zzsn.leaderbase.config;

import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.entity.CharacterCorrelationEnterprise;
import com.zzsn.leaderbase.service.CharacterBasicInfoService;
import com.zzsn.leaderbase.service.CharacterCorrelationEnterpriseService;
import com.zzsn.leaderbase.service.IGeneratorIdService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/7 11:18
 * @Content:  企业高管数据表中的数据导入到人物库中临时处理的逻辑
 */
@Slf4j
@Component
public class QiyegaoguanExcutor implements CommandLineRunner {
    ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private final Integer PERIOD=60*60*24*365;

    //生成id
    @Autowired
    IGeneratorIdService generatorIdService;

    @Autowired
    CharacterBasicInfoService characterBasicInfoService;
    @Autowired
    CharacterCorrelationEnterpriseService characterCorrelationEnterpriseService;

    @Override
    public void run(String... args) {
        scheduledExecutorService.scheduleAtFixedRate(()->{
            //run2();
        },5,PERIOD, TimeUnit.SECONDS);
    }


    void run2(){
        try (BufferedReader br = new BufferedReader(new FileReader("D:\\555.txt"))) {
            String line;
            while ((line = br.readLine()) != null) {
                // 处理每行的逻辑
                String id = line.replace("\"", "");
                String[] arr = line.split(",");
                id = arr[0];
                Long sort = Long.parseLong(arr[1]);
                String uid = generatorIdService.getIdNo();

                CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
                characterBasicInfo.setId(id);
                characterBasicInfo.setUid(uid);
                characterBasicInfoService.updateById(characterBasicInfo);

                //人物企业信息
                CharacterCorrelationEnterprise characterCorrelationEnterprise = new CharacterCorrelationEnterprise();
                characterCorrelationEnterprise.setId(id);
                characterCorrelationEnterprise.setUid(uid);
                characterCorrelationEnterprise.setSort(sort);
                characterCorrelationEnterpriseService.updateById(characterCorrelationEnterprise);
                System.out.println("id:" + id);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

}
