package com.zzsn.leaderbase.vo;

import lombok.Data;

/**
 * 根据关键词从ES中查询重要报道
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/4 16:12
 * @Content:
 */
@Data
public class RelatedReportsVo {

    //当前页码，默认值为1
    private Integer pageNo = 1;

    //分页偏移量 根据 pageNo 和 pageSize 计算得到
    private Integer offset;

    //每页数量，默认值为10
    private Integer pageSize = 10;

    //排序字段，多个排序字段用逗号分隔
    private String column = "publishDate";
    //降序DESC 升序 ASC 默认为DESC
    private String order = "DESC";

    private String keyword;

}
