package com.zzsn.leaderbase.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
@TableName("correlation_information")
public class CorrelationInformation extends Model<CorrelationInformation> {

  private static final long serialVersionUID = 1L;

  //
  private String id;
  //关联人物id
  private String uid;
  //类型: 1重要讲话、2相关报道
  private Long type;
  //关联资讯所在索引
  private String articleIndex;
  //关联资讯id
  private String articleId;
  //关联资讯标题
  private String articleTitle;
  //关联资讯摘要
  private String articleSummary;
  //关联资讯内容
  private String articleContent;
  //资讯来源
  private String articleSource;
  //资讯发布时间
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date articlePublishDate;
  //创建时间
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  //启停状态  1启 0停
  private Long status;
  //备注
  private String remarks;

}
