package com.zzsn.leaderbase.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.leaderbase.entity.CharacterExtractInfo;
import com.zzsn.leaderbase.vo.CheckVo;
import com.zzsn.leaderbase.vo.ExtractListVo;
import com.zzsn.leaderbase.vo.Result;

import java.util.List;

public interface CharacterExtractInfoService extends IService<CharacterExtractInfo> {

    /**
     * 根据 根据职位 工作单位 姓名去重
     * curStation, curWorkPlace, person
     * duty, company, name
     *
     * 有重复数据时返回true
     * 没有重复数据时返回false
     * @param curStation
     * @param curWorkPlace
     * @param person
     * @return
     */
    boolean deduplication(String curStation, String curWorkPlace, String person);

    Result<?> addBulk (List<CharacterExtractInfo> list);

    Result<?> getList(ExtractListVo extractListVo);

    Result<?> del(String id);

    Result<?> checkNewlyAdded(CheckVo checkVo);

    Result<?> checkMerge(CheckVo checkVo);

    String getOriginBySid(String sid);
}
