package com.zzsn.leaderbase.util;

import cn.hutool.core.date.DateUtil;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.entity.ExecutiveNew;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description: 获取用户登录信息
 * @Author: jeecg-boot
 * @Date:   2024-01-04
 * @Version: V1.0
 */
@Slf4j
public class SyncUtil {

	/**
	 * 转换为采集要求的格式
	 * @param basicInfo
	 * @return
	 */
	public static ExecutiveNew convertToCaiji(CharacterBasicInfo basicInfo){
		ExecutiveNew executive = new ExecutiveNew();
		executive.setName(basicInfo.getName());
		executive.setSocialCreditCode(basicInfo.getSocialCreditCode());
		executive.setCompanyName(basicInfo.getDepartment());
		executive.setPosition(basicInfo.getDuty());
		executive.setGender(basicInfo.getSex());
		executive.setEducation(basicInfo.getEducation());
		executive.setEmploymentDate(basicInfo.getTakeOfficeTime());
		executive.setBriefInfo(basicInfo.getBiographicalNotes());

		executive.setStateFlag("在职".equals(basicInfo.getTakeOfficeStatus())?0:1);
		return executive;
	}

	/**
	 * 转换为克虏宝要求的格式
	 * @param executive
	 * @return
	 */
	public static CharacterBasicInfo convertToClb(ExecutiveNew executive){
		CharacterBasicInfo basicInfo = new CharacterBasicInfo();
		basicInfo.setName(executive.getName());
		basicInfo.setSocialCreditCode(executive.getSocialCreditCode());
		basicInfo.setDepartment(executive.getCompanyName());
		basicInfo.setDuty(executive.getPosition());
		basicInfo.setSex(executive.getGender());
		basicInfo.setEducation(executive.getEducation());
		basicInfo.setTakeOfficeTime(executive.getEmploymentDate());
		basicInfo.setBiographicalNotes(executive.getBriefInfo());
		//设置采集时间为最后的更新时间
		basicInfo.setUpdateTime(DateUtil.parseDateTime(executive.getCreateTime()));

		basicInfo.setCategory("3");
		basicInfo.setTakeOfficeStatus("在职");
		basicInfo.setMainEntry(1);
		basicInfo.setStatus(1L);
		return basicInfo;
	}
}
