package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.entity.CharacterExtractInfo;
import com.zzsn.leaderbase.mapper.CharacterExtractInfoMapper;
import com.zzsn.leaderbase.service.CharacterBasicInfoService;
import com.zzsn.leaderbase.service.CharacterExtractInfoService;
import com.zzsn.leaderbase.service.IGeneratorIdService;
import com.zzsn.leaderbase.vo.CheckVo;
import com.zzsn.leaderbase.vo.ExtractListVo;
import com.zzsn.leaderbase.vo.Result;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

@Service
public class CharacterExtractInfoServiceImpl extends ServiceImpl<CharacterExtractInfoMapper, CharacterExtractInfo> implements CharacterExtractInfoService {

    //生成id
    @Autowired
    IGeneratorIdService generatorIdService;
    @Autowired
    CharacterBasicInfoService characterBasicInfoService;

    /**
     * 数据重复返回true  数据不重复，返回false
     * @param curStation
     * @param department
     * @param person
     * @return
     */
    @Override
    public boolean deduplication(String curStation, String department, String person) {
        Integer count = baseMapper.deduplication(curStation, department, person);
        if(count == 0){ return false; }
        else { return true; }
    }

    @Override
    public Result<?> addBulk(List<CharacterExtractInfo> list) {
        this.saveBatch(list);
        return Result.OK();
    }

    @Override
    public Result<?> getList(ExtractListVo extractListVo) {
        List<CharacterExtractInfo> list = baseMapper.getList(extractListVo);
        Integer total = baseMapper.getListCount(extractListVo);

        IPage page = new Page();
        page.setRecords(list);
        page.setTotal(total);
        Integer pageNo = extractListVo.getPageNo();
        Integer pageSize= extractListVo.getPageSize();
        page.setCurrent(pageNo);
        page.setSize(pageSize);
        return Result.OK(page);
    }

    @Override
    public Result<?> del(String id) {
        List<String> ids = Arrays.asList(id.split(","));
        return Result.OK(this.removeByIds(ids));
    }

    @Override
    public Result<?> checkNewlyAdded(CheckVo checkVo) {
        //查询审核人物信息
        String extractId = checkVo.getExtractId();
        CharacterExtractInfo extractInfo = this.getById(extractId);

        //保存人物信息
        CharacterBasicInfo character = checkVo.getCharacter();
        character=convertCharacter(character,extractInfo);
        character.setUid(generatorIdService.getIdNo());
        Boolean characterRes = characterBasicInfoService.save(character);
        if(!characterRes)
            return Result.error("人物信息保存失败");
        //修改审核状态
        Boolean updateCheck = updateExtractInfoCheckStatus(extractId);
        if(!updateCheck)
            return Result.error("审核状态更改失败！");

        return Result.OK(character);
    }


    @Override
    public Result<?> checkMerge(CheckVo checkVo) {
        //查询审核人物信息
        String extractId = checkVo.getExtractId();
        CharacterExtractInfo extractInfo = this.getById(extractId);
        //查询疑似人物信息(主)
        String suspectedId = checkVo.getSuspectedId();
        CharacterBasicInfo suspectedInfo = characterBasicInfoService.getById(suspectedId);
        String uid = suspectedInfo.getUid();
       //同步疑似人物uid
        syncSuspectedUid(uid,checkVo.getSubSuspectedIds());
        //前端传的人物信息
        CharacterBasicInfo character = checkVo.getCharacter();

        Boolean opFlag;
        //相同 更新
        if(checkSimilarPerson(suspectedInfo,character)){
            opFlag =synCharacterBasicInfo(character,suspectedId);
        }else{//新建人物信息
            character=convertCharacter(character,extractInfo);
            character.setUid(uid );
            opFlag = characterBasicInfoService.save(character);
            //人物信息为现任，则将该人物的原现任信息修改为历任
            if("在职".equals(character.getTakeOfficeStatus())){
                LambdaUpdateWrapper<CharacterBasicInfo> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(CharacterBasicInfo::getId, suspectedId)
                        .set(CharacterBasicInfo::getTakeOfficeStatus, "历任")
                        .set(CharacterBasicInfo::getMainEntry,0);
                characterBasicInfoService.update(updateWrapper);
            }
        }
        if(!opFlag)
            return Result.error("人物信息操作失败");
        //修改审核状态
        Boolean updateCheck = updateExtractInfoCheckStatus(extractId);
        if(!updateCheck)
            return Result.error("审核状态更改失败！");

        return Result.OK(character);
    }


    private  CharacterBasicInfo convertCharacter( CharacterBasicInfo character ,CharacterExtractInfo extractInfo){
        String id = Long.toString(generatorIdService.getOrderId());
        character.setId(id);
        character.setCreateTime(new Date());
        character.setUpdateTime(new Date());
        character.setMainEntry(1);
        character.setArticleId(extractInfo.getArticleId());
        character.setArticleIndex(extractInfo.getArticleIndex());
        character.setArticleTitle(extractInfo.getArticleTitle());
        character.setArticleOrigin(extractInfo.getArticleOrigin());
        character.setUpdateDesc(extractInfo.getUpdateDesc());
        return character;
    }

    //更新审核状态
    private boolean updateExtractInfoCheckStatus(String extractId ){
        LambdaUpdateWrapper<CharacterExtractInfo> extractWrapper = new LambdaUpdateWrapper<>();
        extractWrapper.eq(CharacterExtractInfo::getId, extractId)
                .set(CharacterExtractInfo::getCheckStatus, 1)
                .set(CharacterExtractInfo::getUpdateTime, new Date());
        return this.update(extractWrapper);
    }

    //同步疑似人物uid和主疑似人物uid保持一致
    private void syncSuspectedUid(String uid,List<String> subSuspectedIds){
        if(CollectionUtils.isNotEmpty(subSuspectedIds)){
            LambdaUpdateWrapper<CharacterBasicInfo> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(CharacterBasicInfo::getId, subSuspectedIds)
                    .set(CharacterBasicInfo::getUid, uid)
                    .set(CharacterBasicInfo::getUpdateTime, new Date());
            characterBasicInfoService.update(updateWrapper);
        }
    }

    //判断人物信息是否和主疑似人物信息一致（姓名、单位、职务）
    private boolean checkSimilarPerson(CharacterBasicInfo suspectedInfo,CharacterBasicInfo character){
        return StringUtils.equals(suspectedInfo.getName(), character.getName())
                && StringUtils.equals(suspectedInfo.getDepartment(), character.getDepartment())
                && StringUtils.equals(suspectedInfo.getDuty(), character.getDuty());
    }

    //更新主疑似人物信息
    private boolean synCharacterBasicInfo(CharacterBasicInfo character, String suspectedId){
        LambdaUpdateWrapper<CharacterBasicInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(CharacterBasicInfo::getId, suspectedId);
        updateWrapper.set(StringUtils.isNotEmpty(character.getName()), CharacterBasicInfo::getName, character.getName());
        updateWrapper.set(StringUtils.isNotEmpty(character.getSex()), CharacterBasicInfo::getSex, character.getSex());
        updateWrapper.set(StringUtils.isNotEmpty(character.getBirthplace()), CharacterBasicInfo::getBirthplace, character.getBirthplace());
        updateWrapper.set(StringUtils.isNotEmpty(character.getBirthday()), CharacterBasicInfo::getBirthday, character.getBirthday());
        updateWrapper.set(StringUtils.isNotEmpty(character.getNativePlace()), CharacterBasicInfo::getNativePlace, character.getNativePlace());
        updateWrapper.set(StringUtils.isNotEmpty(character.getSchool()), CharacterBasicInfo::getSchool, character.getSchool());
        updateWrapper.set(StringUtils.isNotEmpty(character.getSpeciality()), CharacterBasicInfo::getSpeciality, character.getSpeciality());
        updateWrapper.set(StringUtils.isNotEmpty(character.getEducation()), CharacterBasicInfo::getEducation, character.getEducation());
        updateWrapper.set(StringUtils.isNotEmpty(character.getExpertOccupation()), CharacterBasicInfo::getExpertOccupation, character.getExpertOccupation());
        updateWrapper.set(StringUtils.isNotEmpty(character.getHeadSculpture()), CharacterBasicInfo::getHeadSculpture, character.getHeadSculpture());
        updateWrapper.set(StringUtils.isNotEmpty(character.getBiographicalNotes()), CharacterBasicInfo::getBiographicalNotes, character.getBiographicalNotes());
        //职位状态
        updateWrapper.set(StringUtils.isNotEmpty(character.getTakeOfficeStatus()), CharacterBasicInfo::getTakeOfficeStatus, character.getTakeOfficeStatus());
        updateWrapper.set(CharacterBasicInfo::getUpdateTime , new Date());
        return characterBasicInfoService.update(updateWrapper);
    }
}
