package com.zzsn.leaderbase.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.vo.BasicInfoListVo;
import com.zzsn.leaderbase.vo.CharacterListVo;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.Result;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:35
 * @Content:
 */
public interface CharacterBasicInfoService extends IService<CharacterBasicInfo> {

    CharacterVo getByUid(String uid);

    CharacterBasicInfo getOneById(String id);

    IPage<CharacterBasicInfo> getList(BasicInfoListVo basicInfoListVo);

    List<CharacterVo> checkList(String articleId,String checkResult);

    List<CharacterBasicInfo> getListByName(String name);

    Integer deduplication(String duty, String company, String name);

    List<CharacterBasicInfo> getData(String time);

    List<CharacterBasicInfo> getPreviousDuty(String uid);

    List<String> getCorrelationByUid(String uid);

    List<CharacterVo> getByOriginalId(String id);

    Result<?> add(CharacterBasicInfo characterBasicInfo);

    Result<?> edit(CharacterBasicInfo characterBasicInfo);

    Boolean del(String id);

    Result<?> correlation(CharacterBasicInfo characterBasicInfo);

    Result<?> correlationEdit(CharacterBasicInfo characterBasicInfo);
}
