package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CorrelationEnterprise;
import com.zzsn.leaderbase.mapper.CorrelationEnterpriseMapper;
import com.zzsn.leaderbase.service.CorrelationEnterpriseService;
import com.zzsn.leaderbase.vo.DetailsListVo;
import com.zzsn.leaderbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/5 16:45
 * @Content:
 */
@Service
public class CorrelationEnterpriseServiceImpl extends ServiceImpl<CorrelationEnterpriseMapper, CorrelationEnterprise> implements CorrelationEnterpriseService {

    @Autowired
    CorrelationEnterpriseMapper correlationEnterpriseMapper;

    @Override
    public Result<?> getCorrelationEnterpriseList(DetailsListVo detailsListVo) {

        String uid = detailsListVo.getUid();

        LambdaQueryWrapper<CorrelationEnterprise> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(CorrelationEnterprise::getUid, uid);
        lambdaQuery.orderByDesc(CorrelationEnterprise::getSocialCreditCode);
        StringBuffer sb = new StringBuffer()
                .append(" limit ")
                .append(detailsListVo.getOffset())
                .append(",")
                .append(detailsListVo.getPageSize());
        lambdaQuery.last(sb.toString());
        List<CorrelationEnterprise> list = correlationEnterpriseMapper.selectList(lambdaQuery);

        return Result.OK(list);
    }
}
