package com.zzsn.leaderbase.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 人物变更历史记录表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("character_change_info_history")
public class CharacterChangeInfoHistory extends Model<CharacterChangeInfoHistory> {
  private static final long serialVersionUID = 1L;

  //主键
  @TableId(value = "id", type = IdType.ASSIGN_ID)
  private String id;
  //关联人物id
  private String uid;
  //人物名称
  private String name;
  //原部门 原单位 原企业
  private String departmentOriginal;
  //原职务
  private String dutyOriginal;
  //部门 单位 企业(现)
  private String department;
  //职务(现)
  private String duty;
  //任职时间
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date takeOfficeTime;
  //任职状态
  private String takeOfficeStatus;
  //变更链接
  private String changeUrl;
  //职务变更时间
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date dutiesUpdateTime;
  //职务变更原因
  private String dutiesUpdateReason;
  //是否审核  1是 0否
  private Long checkStatus;
  //是否审核通过 0未通过 1通过 2待定
  private Long checkResult;
  //关联资讯id
  private String articleId;
  //关联资讯标题
  private String articleTitle;
  //变更描述
  private String updateDesc;
  //创建人
  private String createBy;
  //创建时间
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  //更新人
  private String updateBy;
  //更新时间
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date updateTime;
  //启停状态  1启 0停
  private Long status;

}
