package com.zzsn.leaderbase.controller;

import com.zzsn.leaderbase.service.CharacterInfoService;
import com.zzsn.leaderbase.vo.CharacterListVo;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 9:26
 * @Content: 人物信息操作
 */
@RestController
@RequestMapping("/api/character")
public class CharacterInfoContorller {

    @Autowired
    CharacterInfoService characterInfoService;

    /**
     * 新增人物基本信息和职务变动
     * @param characterVo
     * @return
     */
    @PostMapping("/add")
    public Result<?> add(@RequestBody CharacterVo characterVo){
        return characterInfoService.add(characterVo);
    }

    /**
     * 根据人物uid查询人物信息
     * @param uid
     * @return
     */
    @GetMapping("getByUid")
    public Result<?> getByUid(@RequestParam(name="uid",required=true) String uid){
        return Result.OK(characterInfoService.getByUid(uid));
    }

    /**
     * 根据人物id主键查询
     * @param id
     * @return
     */
    @GetMapping
    public Result<?> getById(@RequestParam(name="id",required=true) String id){
        return Result.OK(characterInfoService.getById(id));
    }

    /**
     * 根据人物id修改信息
     * @param characterVo
     * @return
     */
    @PostMapping("/edit")
    public Result<?> edit(@RequestBody CharacterVo characterVo){
        return characterInfoService.edit(characterVo);
    }

    /**
     * 条件分页查询
     * @param characterListVo
     * @return
     */
    @PostMapping("/list")
    public Result<?> list(@RequestBody CharacterListVo characterListVo){
        return Result.OK(characterInfoService.list(characterListVo));
    }

    //审核


}
