package com.zzsn.leaderbase.entity;

import java.io.Serializable;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * @Description: 信息
 * @Author: jeecg-boot
 * @Date:   2024-02-29
 * @Version: V1.0
 */
@Data
@TableName("character_change_info_extract")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="character_change_info_extract对象", description="信息")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CharacterChangeInfoExtract {
    
	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
	private String id;
	/**关联人物id*/
	@Excel(name = "关联人物id", width = 15)
    @ApiModelProperty(value = "关联人物id")
	private String uid;
	/**人物名称*/
	@Excel(name = "人物名称", width = 15)
    @ApiModelProperty(value = "人物名称")
	private String name;
	/**原部门 原单位 原企业*/
	@Excel(name = "原部门 原单位 原企业", width = 15)
    @ApiModelProperty(value = "原部门 原单位 原企业")
	private String departmentOriginal;
	/**原职务*/
	@Excel(name = "原职务", width = 15)
    @ApiModelProperty(value = "原职务")
	private String dutyOriginal;
	/**部门 单位 企业(现)*/
	@Excel(name = "部门 单位 企业(现)", width = 15)
    @ApiModelProperty(value = "部门 单位 企业(现)")
	private String department;
	/**职务(现)*/
	@Excel(name = "职务(现)", width = 15)
    @ApiModelProperty(value = "职务(现)")
	private String duty;
	/**任职时间*/
	@Excel(name = "任职时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "任职时间")
	private Date takeOfficeTime;
	/**任职状态*/
	@Excel(name = "任职状态", width = 15)
    @ApiModelProperty(value = "任职状态")
	private String takeOfficeStatus;
	/**变更链接*/
	@Excel(name = "变更链接", width = 15)
    @ApiModelProperty(value = "变更链接")
	private String changeUrl;
	/**职务变更时间*/
	@Excel(name = "职务变更时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "职务变更时间")
	private Date dutiesUpdateTime;
	/**职务变更原因*/
	@Excel(name = "职务变更原因", width = 15)
    @ApiModelProperty(value = "职务变更原因")
	private String dutiesUpdateReason;
	/**是否审核  1是 0否*/
	@Excel(name = "是否审核  1是 0否", width = 15)
    @ApiModelProperty(value = "是否审核  1是 0否")
	private Integer checkStatus;
	/**是否审核通过 0未通过 1通过 2待定*/
	@Excel(name = "是否审核通过 0未通过 1通过 2待定", width = 15)
    @ApiModelProperty(value = "是否审核通过 0未通过 1通过 2待定")
	private Integer checkResult;
	/**关联资讯id*/
	@Excel(name = "关联资讯id", width = 15)
    @ApiModelProperty(value = "关联资讯id")
	private String articleId;
	/**关联资讯标题*/
	@Excel(name = "关联资讯标题", width = 15)
    @ApiModelProperty(value = "关联资讯标题")
	private String articleTitle;
	/**变更描述*/
	@Excel(name = "变更描述", width = 15)
    @ApiModelProperty(value = "变更描述")
	private String updateDesc;
	/**创建时间*/
	@Excel(name = "创建时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
	private Date createTime;
}
