package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.mapper.CharacterBasicInfoMapper;
import com.zzsn.leaderbase.service.CharacterBasicInfoService;
import com.zzsn.leaderbase.service.CharacterTagService;
import com.zzsn.leaderbase.service.IGeneratorIdService;
import com.zzsn.leaderbase.vo.BasicInfoListVo;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:35
 * @Content: 人物基本信息
 */
@Service
public class CharacterBasicInfoServiceImpl extends ServiceImpl<CharacterBasicInfoMapper, CharacterBasicInfo> implements CharacterBasicInfoService {

    //生成id
    @Autowired
    IGeneratorIdService generatorIdService;

    @Autowired
    CharacterTagService characterTagService;

    @Override
    public CharacterVo getByUid(String uid) {
        return baseMapper.getByUid(uid);
    }

    @Override
    public CharacterBasicInfo getOneById(String id) {
        CharacterBasicInfo basicInfo = this.getById(id);
        return basicInfo;
    }

    @Override
    public IPage<CharacterBasicInfo> getList(BasicInfoListVo basicInfoListVo) {
        List<CharacterBasicInfo> list = baseMapper.getList(basicInfoListVo);
        Integer total = baseMapper.getListCount(basicInfoListVo);
        List<CharacterBasicInfo> listNew =setListValues(list,basicInfoListVo);
        IPage page = new Page();
        page.setRecords(listNew);
        page.setTotal(total);
        Integer pageNo = basicInfoListVo.getPageNo();
        Integer pageSize= basicInfoListVo.getPageSize();
        page.setCurrent(pageNo);
        page.setSize(pageSize);
        return page;
    }
    
    private List<CharacterBasicInfo> setListValues(List<CharacterBasicInfo> list, BasicInfoListVo basicInfoListVo) {
        //查询结果替换主数据
        List<CharacterBasicInfo> listNew=new ArrayList<>(list.size());
        for (CharacterBasicInfo characterBasicInfo : list) {
            Integer mainEntry = characterBasicInfo.getMainEntry();
            if(mainEntry == 0){
                QueryWrapper<CharacterBasicInfo> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("uid", characterBasicInfo.getUid())
                        .eq("main_entry",1);
                List<CharacterBasicInfo> mainList = this.list(queryWrapper);
                if(mainList.size() > 0){
                    listNew.add(mainList.get(0));
                } else {
                    listNew.add(characterBasicInfo);
                }
            } else {
                listNew.add(characterBasicInfo);
            }
        }
        //判断是否有关联数据
        hasChild(listNew);
        //记录热门标签
        String tagId = basicInfoListVo.getTagId();
        if(tagId != null && tagId.length() >0){
            String[] tagIdArr = tagId.split(",");
            for (String s : tagIdArr) {
                characterTagService.addTagTop(s);
            }
        }
        return list;
    }
    
    //判断是否有关联数据
    private List<CharacterBasicInfo> hasChild(List<CharacterBasicInfo> list){
        if(list != null && list.size() > 0 ){
            List<String> uidList = new ArrayList<>();
            list.forEach(info -> { uidList.add(info.getUid()); });
            QueryWrapper<CharacterBasicInfo> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("uid", uidList)
                    .ne("main_entry",1).select("id","uid");
            List<CharacterBasicInfo> hasChildList = this.list(queryWrapper);
            if(hasChildList.size() > 0){
                Map<String, List<CharacterBasicInfo>> groupList = hasChildList.stream().collect(Collectors.groupingBy(e -> e.getUid()));
                list.forEach(info -> {
                    String uid = info.getUid();
                    List<CharacterBasicInfo> groupUid = groupList.get(uid);
                    if(groupUid != null && groupUid.size() != 0){
                        info.setHasChild(1);
                    }
                });
            }
        }
        return list;
    }


    @Override
    public List<CharacterVo> checkList(String articleId, String checkResult) {
        return baseMapper.checkList(articleId,checkResult);
    }

    @Override
    public List<CharacterBasicInfo> getListByName(String name) {
        return baseMapper.getListByName(name);
    }

    @Override
    public Integer deduplication(String duty, String company, String name) {
        Integer count = baseMapper.deduplication(duty, company, name);
        return count;
    }

    @Override
    public List<CharacterBasicInfo> getData(String time) {
        LambdaQueryWrapper<CharacterBasicInfo> lambdaQuery = Wrappers.lambdaQuery();
        if(!"".equals(time)){
            lambdaQuery.ge(CharacterBasicInfo::getCreateTime, time);
        }
        lambdaQuery.orderByAsc(CharacterBasicInfo::getCreateTime);
        lambdaQuery.select(CharacterBasicInfo::getUid,CharacterBasicInfo::getName);
        List<CharacterBasicInfo> list = baseMapper.selectList(lambdaQuery);
        return list;
    }

    @Override
    public List<CharacterBasicInfo> getPreviousDuty(String uid) {
        return baseMapper.getPreviousDuty(uid);
    }

    @Override
    public List<String> getCorrelationByUid(String uid) {
        return baseMapper.getCorrelationByUid(uid);
    }

    @Override
    public List<CharacterVo> getByOriginalId(String id) {
        return baseMapper.getByOriginalId(id);
    }

    @Override
    public Result<?> add(CharacterBasicInfo characterBasicInfo) {
        String id = Long.toString(generatorIdService.getOrderId());
        characterBasicInfo.setId(id);
        characterBasicInfo.setCreateTime(new Date());

        String uid = generatorIdService.getIdNo();
        characterBasicInfo.setUid(uid);
        characterBasicInfo.setMainEntry(1);

        Boolean res = this.save(characterBasicInfo);
        return Result.OK(res);
    }

    @Override
    public Result<?> edit(CharacterBasicInfo characterBasicInfo) {
        characterBasicInfo.setUpdateTime(new Date());
        Boolean res = this.updateById(characterBasicInfo);
        return Result.OK(res);
    }

    @Override
    public Boolean del(String id) {
        List<String> ids = Arrays.asList(id.split(","));
        return this.removeByIds(ids);
    }

    @Override
    public Result<?> correlation(CharacterBasicInfo characterBasicInfo) {
        //传过来的id是操作的数据id
        String id = characterBasicInfo.getId();
        CharacterBasicInfo newInfo = this.getById(id);

        String newId = Long.toString(generatorIdService.getOrderId());
        characterBasicInfo.setId(newId);
        characterBasicInfo.setMainEntry(0);
        characterBasicInfo.setCategory(newInfo.getCategory());
        characterBasicInfo.setCreateTime(new Date());
        Boolean res = this.save(characterBasicInfo);
        return Result.OK(res);
    }

    @Override
    public Result<?> correlationEdit(CharacterBasicInfo characterBasicInfo) {
        characterBasicInfo.setUpdateTime(new Date());
        Boolean res = this.updateById(characterBasicInfo);
        return Result.OK(res);
    }

    /**
     * 根据社会信用代码查询公司名称
     * @param socialCreditCode
     * @return
     */
    @Override
    public String getDepartmentCreditCode(String socialCreditCode) {
        return baseMapper.getDepartmentCreditCode(socialCreditCode);
    }

    /**
     * 根据社会信用代码查询相关联高管人员
     * @param socialCreditCode
     * @return
     */
    @Override
    public List<CharacterBasicInfo> getBasicInfoByCreditCode(String socialCreditCode) {
        return baseMapper.getBasicInfoByCreditCode(socialCreditCode);
    }

    @Override
    public List<Map<String, String>> getDepartment(String socialCreditCode, String department, String keyword) {
        if(keyword != null && keyword.length() > 0){
            if((keyword.length() == 18 || keyword.length() == 19) && keyword.matches("[0-9].*|[Zz].*")){
                socialCreditCode = keyword;
            } else {
                department = keyword;
            }
            keyword = null;
        }
        return baseMapper.getDepartment(socialCreditCode, department, keyword);
    }
    
    @Override
    public List<CharacterBasicInfo> getAllList(BasicInfoListVo basicInfoListVo) {
        List<CharacterBasicInfo> list = baseMapper.getAllList(basicInfoListVo);
        List<CharacterBasicInfo> listNew =setListValues(list,basicInfoListVo);
        return listNew;
    }

    @Override
    public CharacterBasicInfo getBasicInfoByUid(String uid) {
        LambdaQueryWrapper<CharacterBasicInfo> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(CharacterBasicInfo::getUid,uid);
        return baseMapper.selectOne(queryWrapper);
    }

    @Override
    public CharacterBasicInfo getByNameAndByDepartment(String category, String name, String department) {
        LambdaQueryWrapper<CharacterBasicInfo> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(CharacterBasicInfo::getCategory,category);
        queryWrapper.eq(CharacterBasicInfo::getName,name);
        queryWrapper.eq(CharacterBasicInfo::getDepartment,department);
        List<CharacterBasicInfo> characterBasicInfos = baseMapper.selectList(queryWrapper);
        if(characterBasicInfos!=null && characterBasicInfos.size()>0){
            return characterBasicInfos.get(0);
        }
        return null;
    }
}
