package com.zzsn.leaderbase.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.leaderbase.constant.CommonConstant;
import com.zzsn.leaderbase.entity.CharacterChangeInfoExtract;
import com.zzsn.leaderbase.mapper.CharacterChangeInfoExtractMapper;
import com.zzsn.leaderbase.util.EsDateUtil;
import com.zzsn.leaderbase.util.EsUtil;
import com.zzsn.leaderbase.util.HttpUtil;
import com.zzsn.leaderbase.vo.InfoExtractionParam;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.*;

@Service
@Slf4j
public class DealLeaderDataService {
    @Autowired
    private EsUtil esUtil;
    @Value("${python.getInfoUrl}")
    private String relationEntityUrl;
    @Autowired
    RedisTemplate redisTemplate;
    @Resource
    private CharacterChangeInfoExtractService characterChangeInfoExtractService;


    public void getData() throws IOException {
        log.info("获取数据");
        Object object = redisTemplate.opsForValue().get(CommonConstant.LAST_TIME);
        String startTime = null;
        if (object != null) {
            startTime = object.toString();
        } else {
            startTime = "2023-01-01 12:12:12";
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder1 = QueryBuilders.boolQuery()
                .must(QueryBuilders.termsQuery("subjectId", Arrays.asList("1750716233967157250", "1750716067187048450")))
                .must(QueryBuilders.termsQuery("id", Arrays.asList("1750716067187048450284182235652014131")));

        boolQueryBuilder1.filter(QueryBuilders.rangeQuery("createDate").gte(EsDateUtil.esFieldDateFormat(startTime)));
        searchSourceBuilder.query(boolQueryBuilder1);
        searchSourceBuilder.sort("createDate", SortOrder.DESC);

        Integer pagesize = 1;
        for (int i = 1; true; i++) {
            Page<InfoExtractionParam> subjectdatabase = esUtil.queryPage("subjectdatabase", searchSourceBuilder, InfoExtractionParam.class, i, pagesize);
            List<InfoExtractionParam> records = subjectdatabase.getRecords();
            log.info("页码：{},总页：{},总数量{}", i, subjectdatabase.getPages(), subjectdatabase.getTotal());
            List<CharacterChangeInfoExtract > list=new ArrayList<>();
            if (CollectionUtil.isNotEmpty(records)) {
                JSONObject jsonObjectParam = new JSONObject();
                Map<String, List<InfoExtractionParam>> map = new HashMap<>();
                map.put("data_list", records);
                jsonObjectParam.put("data", map);
                log.info("request");
                String result = HttpUtil.doPost(relationEntityUrl, jsonObjectParam, 40000);
                log.info("response:{}",result);
                Object objectResult = parseResult(result);
                JSONArray dataResultList = null;
                if (null != objectResult) {
                    dataResultList = (JSONArray) JSONArray.parse(objectResult.toString());
                }
                if (dataResultList != null) {
                    for (Object dataResultObject : dataResultList) {
                        JSONObject dataResult = JSONObject.parseObject(dataResultObject.toString());
                    if(dataResult.get("infos")!=null){
                        JSONArray jsonArray= (JSONArray) JSONArray.parse(String.valueOf(dataResult.get("infos")));
                        for (Object data : jsonArray) {
                            JSONObject temp = JSONObject.parseObject(data.toString());
                            list.add(CharacterChangeInfoExtract.builder()
                                    .updateDesc(temp.get("updateDesc")!=null?temp.get("updateDesc").toString():"")
                                    .dutyOriginal(temp.get("oriStation")!=null?temp.get("oriStation").toString():"")
                                    .duty(temp.get("curStation")!=null?temp.get("curStation").toString():"")
                                    .name(temp.get("person")!=null?temp.get("person").toString():"")
                                    .articleTitle(dataResult.get("id")!=null?dataResult.get("id").toString():"")
                                    .articleId(dataResult.get("id")!=null?dataResult.get("id").toString():"")
                                    .build());
                        }
                    }
                    }
                }
                if(!list.isEmpty()){
                    characterChangeInfoExtractService.saveBatch(list);
                }


            } else {
                log.info("此轮数据处理完毕============================================");
                break;
            }


        }
    }


    private Object parseResult(String result) {
        JSONObject jsonObject = JSONObject.parseObject(result);
        if (null != jsonObject && "true".equals(jsonObject.getString("isHandleSuccess"))) {
            return jsonObject.get("resultData");

        }
        log.error("python 服务结果异常，响应信息{}", result);
        return null;
    }
}
