package com.zzsn.leaderbase.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
@TableName("correlation_enterprise")
public class CorrelationEnterprise extends Model<CorrelationEnterprise> {

  //主键
  @TableId(value = "id", type = IdType.ASSIGN_ID)
  private String id;
  //'关联人物id'
  private String uid;
  //'姓名'
  private String uname;
  //'企业信用代码'
  private String socialCreditCode;
  //'企业名称'
  private String ename;
  //'职位:股东、法人、董事长等'
  private String position;
  //'持股比例'
  private double shareholdingRatio;
  //'创建人'
  private String createBy;
  //'创建时间'
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  //'更新人'
  private String updateBy;
  //'更新时间'
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date updateTime;
  //'启停状态  1启 0停'
  private Long status;
}
