package com.zzsn.leaderbase.controller;

import com.zzsn.leaderbase.service.CharacterDetailsService;
import com.zzsn.leaderbase.service.CorrelationEnterpriseService;
import com.zzsn.leaderbase.service.EsServer;
import com.zzsn.leaderbase.service.LearningAchievementService;
import com.zzsn.leaderbase.service.impl.CisXgraPaperServiceImpl;
import com.zzsn.leaderbase.util.EsUtil;
import com.zzsn.leaderbase.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/4 14:18
 * @Content:
 */
@RestController
@RequestMapping("/api/detail")
public class CharacterDetailsController {

    //重要讲话 相关报道查询
    @Autowired
    CharacterDetailsService characterDetailsService;

    //学术信息
    @Autowired
    CisXgraPaperServiceImpl cisXgraPaperService;

    //学术成果
    @Autowired
    LearningAchievementService learningAchievementService;

    //企业信息
    @Autowired
    CorrelationEnterpriseService correlationEnterpriseService;

    @Autowired
    EsServer esServer;

    /**
     * 重要讲话 相关报道查询
     * @param detailsListVo
     * @return
     */
    @PostMapping("/informationList")
    public Result<?> informationList(@RequestBody DetailsListVo detailsListVo){

        String uid = detailsListVo.getUid();
        if(uid == null || "".equals(uid))
            return Result.error("人物id不能为空！");
        Long type = detailsListVo.getType();
        if(type == null)
            return Result.error("类型type不能为空！");

        Integer pageNo = detailsListVo.getPageNo();
        Integer pageSize= detailsListVo.getPageSize();
        if(pageNo < 1)
            return Result.error("参数pageNo的值不能小于1！");
        if(pageSize < 0)
            return Result.error("参数pageSize的值不能小于0！");
        Integer office = pageSize * (pageNo - 1);
        detailsListVo.setOffset(office);

        return characterDetailsService.informationList(detailsListVo);
    }

    /**
     * ES查询
     * 根据关联咨询索引和id查询咨询详情
     * @param index 关联咨询所在es索引getInformation
     * @param id 关联咨询es id
     * @return
     */
    @GetMapping("/getInformation")
    public Result<?> getInformation(
            @RequestParam(name="index",required=false) String index,
            @RequestParam(name="id",required=true) String id
    ){
        if(id == null || "".equals(id))
            return Result.error("id不能为空！");
        if(index == null || "".equals(index)){
            String[] arr = id.split(",");
            if(arr.length == 2){
                index = arr[0];
                id = arr[1];
            } else {
                return Result.error("索引有误！");
            }
        }

        return esServer.getInformation(index, id);
    }



    /**
     * 学术信息查询
     * 根据人物uid
     * @param uid
     * @return
     */
    @GetMapping("/getCisXgraPaper")
    public Result<?> getCisXgraPaper(@RequestParam(name="uid",required=true) String uid){
        if(uid == null || "".equals(uid))
            Result.error("人物id不能为空！");
        return cisXgraPaperService.getCisXgraPaper(uid);
    }


    /**
     * 学术成果查询
     * @param detailsListVo
     * @return
     */
    @PostMapping("/getLearningAchievementList")
    public Result<?> getLearningAchievementList(@RequestBody DetailsListVo detailsListVo){
        String uid = detailsListVo.getUid();
        if(uid == null || "".equals(uid))
            return Result.error("人物id不能为空！");

        Integer pageNo = detailsListVo.getPageNo();
        Integer pageSize= detailsListVo.getPageSize();
        if(pageNo < 1)
            return Result.error("参数pageNo的值不能小于1！");
        if(pageSize < 0)
            return Result.error("参数pageSize的值不能小于0！");
        Integer office = pageSize * (pageNo - 1);
        detailsListVo.setOffset(office);

        return learningAchievementService.getLearningAchievementList(detailsListVo);
    }


    /**
     * CorrelationEnterprise
     * 相关企业查询
     * @param detailsListVo
     * @return
     */
    @PostMapping("/getCorrelationEnterpriseList")
    public Result<?> getCorrelationEnterpriseList(@RequestBody DetailsListVo detailsListVo) {
        String uid = detailsListVo.getUid();
        if (uid == null || "".equals(uid))
            return Result.error("人物id不能为空！");

        Integer pageNo = detailsListVo.getPageNo();
        Integer pageSize = detailsListVo.getPageSize();
        if (pageNo < 1)
            return Result.error("参数pageNo的值不能小于1！");
        if (pageSize < 0)
            return Result.error("参数pageSize的值不能小于0！");
        Integer office = pageSize * (pageNo - 1);
        detailsListVo.setOffset(office);

        return correlationEnterpriseService.getCorrelationEnterpriseList(detailsListVo);
    }

    /**
     * ES查询
     * 根据uid和人物名称从es库中查询从百度采集的人物信息
     * @param uid
     * @param name
     * @return
     */
    @GetMapping("/getCharacterBaike")
    public Result<?> getCharacterBaike(
            @RequestParam(name="uid",required=true) String uid,
            @RequestParam(name="name",required=true) String name
    ) {
        return esServer.getCharacterBaike(uid, name);
    }


    /**
     * 根据关键字从es中查询相关报道
     * @param relatedReportsVo
     * @return
     */
    @PostMapping("/getRelatedReportsList")
    public Result<?> getRelatedReportsList(@RequestBody RelatedReportsVo relatedReportsVo) {
        //参数校验
        Integer pageNo = relatedReportsVo.getPageNo();
        if(pageNo < 1)
            return Result.error("页码不能小于1！");
        if(relatedReportsVo.getKeyword() == null || "".equals(relatedReportsVo.getKeyword()))
            return Result.error("搜索关键词不能为空！");
        return esServer.getRelatedReportsList(relatedReportsVo);
    }

}
