package com.zzsn.leaderbase.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.service.CharacterBasicInfoService;
import com.zzsn.leaderbase.util.SortUtil;
import com.zzsn.leaderbase.vo.BasicInfoListVo;
import com.zzsn.leaderbase.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/api/character/basic")
public class CharacterBasicInfoController {
    
    @Autowired
    CharacterBasicInfoService characterBasicInfoService;
    
    /**
     * 资讯抽取人物信息分页查询
     * 人物审核列表
     *
     * @param
     * @return
     */
    @PostMapping("/list")
    public Result<?> getList(@RequestBody BasicInfoListVo basicInfoListVo) {
        log.info("人物管理列表:{}", basicInfoListVo);
        Integer office = basicInfoListVo.getPageSize() * (basicInfoListVo.getPageNo() - 1);
        basicInfoListVo.setOffset(office);
        basicInfoListVo.setColumn(SortUtil.humpToLine(basicInfoListVo.getColumn()));
        IPage page = characterBasicInfoService.getList(basicInfoListVo);
        return Result.OK(page);
    }
    
    @GetMapping("/getById")
    public Result<?> getById(@RequestParam(name = "id", required = true) String id) {
        log.info("人物审核根据人物id查询:{}", id);
        CharacterBasicInfo info = characterBasicInfoService.getOneById(id);
        return Result.OK(info);
    }
    
    /**
     * 根据姓名查询 疑似人物查询
     *
     * @param name
     * @return
     */
    @GetMapping("/getListByName")
    public Result<?> getListByName(@RequestParam(name = "name", required = true) String name) {
        log.info("根据人物名称查询疑似人物:{}", name);
        List<CharacterBasicInfo> list = characterBasicInfoService.getListByName(name);
        return Result.OK(list);
    }
    
    /**
     * 新增人物
     */
    @PostMapping("/add")
    public Result<?> add(@RequestBody CharacterBasicInfo characterBasicInfo) {
        log.info("新增人物:{}", characterBasicInfo);
        return characterBasicInfoService.add(characterBasicInfo);
    }
    
    /**
     * 修改人物
     */
    @PostMapping("/edit")
    public Result<?> edit(@RequestBody CharacterBasicInfo characterBasicInfo) {
        log.info("新增人物:{}", characterBasicInfo);
        String id = characterBasicInfo.getId();
        if (id == null || id.length() == 0)
            return Result.error("人物id不能为空");
        return characterBasicInfoService.edit(characterBasicInfo);
    }
    
    /**
     * 根据id删除人物
     *
     * @param id
     * @return
     */
    @GetMapping("/del")
    public Result<?> del(@RequestParam(name = "id", required = true) String id) {
        log.info("根据id删除人物:{}", id);
        Boolean res = characterBasicInfoService.del(id);
        return Result.OK(res);
    }
    
    /**
     * 根据uid查询人物的历任职务
     *
     * @param uid
     * @return
     */
    @GetMapping("/getPreviousDuty")
    public Result<?> getPreviousDuty(@RequestParam(name = "uid", required = true) String uid) {
        log.info("根据uid查询人物的历任职务:{}", uid);
        List<CharacterBasicInfo> list = characterBasicInfoService.getPreviousDuty(uid);
        return Result.OK(list);
    }
    
    /**
     * 关联
     *
     * @param characterBasicInfo
     * @return
     */
    @PostMapping("/correlation")
    public Result<?> correlation(@RequestBody CharacterBasicInfo characterBasicInfo) {
        log.info("关联:{}", characterBasicInfo.getId());
        return characterBasicInfoService.correlation(characterBasicInfo);
    }
    
    /**
     * 修改关联人物
     *
     * @param characterBasicInfo
     * @return
     */
    @PostMapping("/correlationEdit")
    public Result<?> correlationEdit(@RequestBody CharacterBasicInfo characterBasicInfo) {
        log.info("修改关联人物:{}", characterBasicInfo.getId());
        return characterBasicInfoService.correlationEdit(characterBasicInfo);
    }
    
    /**
     * 企业查询
     *
     * @param socialCreditCode 社会信用代码
     * @param department
     * @return
     */
    @GetMapping("/getDepartment")
    public Result<?> getDepartment(@RequestParam(name = "socialCreditCode", required = false) String socialCreditCode,
                                   @RequestParam(name = "department", required = false) String department,
                                   @RequestParam(name = "keyword", required = false) String keyword) {
        log.info("查询企业名称:{}---{}---{}", socialCreditCode, department, keyword);
        List<Map<String, String>> list = characterBasicInfoService.getDepartment(socialCreditCode, department, keyword);
        return Result.OK(list);
    }
    
    /**
     * @param basicInfoListVo 条件封装
     * @描述 查询专家列表
     * @作者 hejinyu
     * @创建时间 2024/12/26
     **/
    @PostMapping("/listAll")
    public Result<?> listAll(@RequestBody BasicInfoListVo basicInfoListVo) {
        //类别过滤为专家
        basicInfoListVo.setCategory("2");
        basicInfoListVo.setColumn(SortUtil.humpToLine(basicInfoListVo.getColumn()));
        List<CharacterBasicInfo> list= characterBasicInfoService.getAllList(basicInfoListVo);
        return Result.OK(list);
    }
    
    /**
     * @param basicInfoListVo 条件封装
     * @描述 查询专家列表（分页，产业链关联专家时查询用）
     * @作者 hejinyu
     * @创建时间 2024/12/26
     **/
    @PostMapping("/pageListAll")
    public Result<?> pageListAll(@RequestBody BasicInfoListVo basicInfoListVo) {
        //类别过滤为专家
        basicInfoListVo.setCategory("2");
        Integer office = basicInfoListVo.getPageSize() * (basicInfoListVo.getPageNo() - 1);
        basicInfoListVo.setOffset(office);
        basicInfoListVo.setColumn(SortUtil.humpToLine(basicInfoListVo.getColumn()));
        IPage page = characterBasicInfoService.getList(basicInfoListVo);
        return Result.OK(page);
    }
}

