package com.zzsn.leaderbase.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
@TableName("character_correlation_enterprise")
public class CharacterCorrelationEnterprise {

  //主键
  private String id;
  //关联人物id
  private String uid;
  //企业信用代码
  private String socialCreditCode;
  //企业名称
  private String ename;
  //职位	股东、法人、董事长等
  private String position;
  //薪资
  private String salary;
  //持股数
  private String shareNum;
  //持股比例
  private String shareRatio;
  //最终受益股份
  private String benefitShare;
  //本届任期
  private String currentTerm;
  //创建人
  private String createBy;
  //创建时间
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  //更新人
  private String updateBy;
  //更新时间
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date updateTime;
  //启停状态  1启 0停
  private long status;
}
