package com.zzsn.leaderbase.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.leaderbase.constant.CommonConstant;
import com.zzsn.leaderbase.entity.CharacterExtractInfo;
import com.zzsn.leaderbase.util.EsDateUtil;
import com.zzsn.leaderbase.util.EsUtil;
import com.zzsn.leaderbase.util.HttpUtil;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.InfoExtractionParam;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.*;

@Service
@Slf4j
public class DealLeaderDataService {
    @Autowired
    private EsUtil esUtil;
    @Value("${python.getInfoUrl}")
    private String relationEntityUrl;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private CharacterInfoService characterInfoService;

    @Autowired
    CharacterExtractInfoService characterExtractInfoService;

    @Autowired
    IGeneratorIdService generatorIdService;



    public void getData() throws IOException {
        log.info("获取数据");
        Object object = redisTemplate.opsForValue().get(CommonConstant.LAST_TIME);
        String startTime = null;
        if (object != null) {
            startTime = object.toString();
        } else {
            startTime = "2023-01-01 12:12:12";
        }
        startTime = "2023-01-01 12:12:12";
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder1 = QueryBuilders.boolQuery()
                .must(QueryBuilders.termsQuery("subjectId", Arrays.asList("1750716233967157250", "1750716067187048450")))
//                .must(QueryBuilders.termsQuery("id", "1750716067187048450299753563117305901","1750716067187048450299753563117305895"))
                /*
                1750716067187048450300259889635377190
                1750716067187048450300259889635377186
                1750716067187048450300208438489890835
                1750716067187048450300061908109869103
                1750716067187048450299753563117305901
                1750716067187048450299753563117305895
                 */
                ;

        boolQueryBuilder1.filter(QueryBuilders.rangeQuery("createDate").gte(EsDateUtil.esFieldDateFormat(startTime)));
        searchSourceBuilder.query(boolQueryBuilder1);
        searchSourceBuilder.sort("createDate", SortOrder.DESC);

        Integer pagesize =10;
        for (int i = 1; true; i++) {
            Page<InfoExtractionParam> page = esUtil.queryPageInfoExtractionParam("subjectdatabase", searchSourceBuilder,  i, pagesize);
            List<InfoExtractionParam> records = page.getRecords();
            log.info("页码：{},数量{},总页：{},总数量{}", i, records.size(),page.getPages(), page.getTotal());

            if (CollectionUtil.isEmpty(records)) {
                log.info("此轮数据处理完毕============================================");
                break;
            }

            JSONObject jsonObjectParam = new JSONObject();

            for (InfoExtractionParam record : records) {
                List<CharacterExtractInfo> list = new ArrayList<>();
                Map<String, List<InfoExtractionParam>> map = new HashMap<>();
                map.put("data_list", Collections.singletonList(record));
                jsonObjectParam.put("data", map);
                JSONArray dataResultList = null;
                try {
                    log.info("request");
                    String result = HttpUtil.doPost(relationEntityUrl, jsonObjectParam, 40000);
                    log.info("response:{}", result);
                    Object objectResult = parseResult(result);
                    if (null != objectResult) {
                        dataResultList = (JSONArray) JSONArray.parse(objectResult.toString());
                    }
                }catch (Exception e){
                    log.error("异常：{}",e.getMessage());
                }
                if (dataResultList != null) {
                    for (Object dataResultObject : dataResultList) {
                        JSONObject dataResult = JSONObject.parseObject(dataResultObject.toString());
                        if (dataResult.get("infos") != null) {
                            JSONArray jsonArray = (JSONArray) JSONArray.parse(String.valueOf(dataResult.get("infos")));
                            for (Object data : jsonArray) {
                                JSONObject temp = JSONObject.parseObject(data.toString());

                                //判重
                                String curStation = temp.get("curStation") != null ? temp.get("curStation").toString() : "";
                                String curWorkPlace = temp.get("curWorkPlace") != null ? temp.get("curWorkPlace").toString() : "";
                                String person = temp.get("person") != null ? temp.get("person").toString() : "";
                                boolean b = characterExtractInfoService.deduplication(curStation,curWorkPlace,person);
                                //b = false;
                                if(b){
                                    log.info("数据重复：{}",data.toString());
                                } else {
                                    String id = Long.toString(generatorIdService.getOrderId());
                                    list.add(CharacterExtractInfo.builder()
                                                    .id(id)
                                                    .name(temp.get("person") != null ? temp.get("person").toString() : "")
                                                    .department(temp.get("curWorkPlace") != null ? temp.get("curWorkPlace").toString() : "")
                                                    .duty(temp.get("curStation") != null ? temp.get("curStation").toString() : "")
                                                    .departmentOriginal(temp.get("oriWorkPlace") != null ? temp.get("oriWorkPlace").toString() : "")
                                                    .dutyOriginal(temp.get("oriStation") != null ? temp.get("oriStation").toString() : "")
                                                    .updateDesc(temp.get("updateDesc") != null ? temp.get("updateDesc").toString() : "")
                                                    .articleIndex(record.getIndex())
                                                    .articleId(record.getId())
                                                    .articleTitle(record.getTitle())
                                                    .articleOrigin(record.getOrigin())
                                                    .checkStatus(0)
                                                    .createTime(new Date())
                                                    .build()
                                            );
                                }
                            }
                        }
                    }
                }
                if (!list.isEmpty()) {
                    characterExtractInfoService.addBulk(list);
                }
            }
            redisTemplate.opsForValue().set(CommonConstant.LAST_TIME, DateUtil.format(new Date(),"yyyy-MM-dd HH:mm:ss"));
        }
    }


    private Object parseResult(String result) {
        JSONObject jsonObject = JSONObject.parseObject(result);
        if (null != jsonObject && "true".equals(jsonObject.getString("isHandleSuccess"))) {
            return jsonObject.get("resultData");

        }
        log.error("python 服务结果异常，响应信息{}", result);
        return null;
    }
}
