package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.mapper.CharacterBasicInfoMapper;
import com.zzsn.leaderbase.service.CharacterBasicInfoService;
import com.zzsn.leaderbase.service.CharacterTagService;
import com.zzsn.leaderbase.service.IGeneratorIdService;
import com.zzsn.leaderbase.vo.BasicInfoListVo;
import com.zzsn.leaderbase.vo.CharacterListVo;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:35
 * @Content: 人物基本信息
 */
@Service
public class CharacterBasicInfoServiceImpl extends ServiceImpl<CharacterBasicInfoMapper, CharacterBasicInfo> implements CharacterBasicInfoService {

    //生成id
    @Autowired
    IGeneratorIdService generatorIdService;

    @Autowired
    CharacterTagService characterTagService;

    @Override
    public CharacterVo getByUid(String uid) {
        return baseMapper.getByUid(uid);
    }

    @Override
    public CharacterBasicInfo getOneById(String id) {
        CharacterBasicInfo basicInfo = this.getById(id);
        return basicInfo;
    }

    @Override
    public IPage<CharacterBasicInfo> getList(BasicInfoListVo basicInfoListVo) {
        List<CharacterBasicInfo> list = baseMapper.getList(basicInfoListVo);
        Integer total = baseMapper.getListCount(basicInfoListVo);

        //判断是否有关联数据
        List<String> uidList = new ArrayList<>();
        list.forEach(info -> { uidList.add(info.getUid()); });
        QueryWrapper<CharacterBasicInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("uid", uidList)
                .ne("main_entry",1).select("id","uid");
        List<CharacterBasicInfo> hasChildList = this.list(queryWrapper);
        if(hasChildList.size() > 0){
            Map<String, List<CharacterBasicInfo>> groupList = hasChildList.stream().collect(Collectors.groupingBy(e -> e.getUid()));
            list.forEach(info -> {
                String uid = info.getUid();
                List<CharacterBasicInfo> groupUid = groupList.get(uid);
                if(groupUid != null && groupUid.size() != 0){
                    info.setHasChild(1);
                }
            });
        }


        //记录热门标签
        //记录热门标签
        String tagId = basicInfoListVo.getTagId();
        if(tagId != null && tagId.length() >0){
            String[] tagIdArr = tagId.split(",");
            for (String s : tagIdArr) {
                characterTagService.addTagTop(s);
            }
        }

        IPage page = new Page();
        page.setRecords(list);
        page.setTotal(total);
        Integer pageNo = basicInfoListVo.getPageNo();
        Integer pageSize= basicInfoListVo.getPageSize();
        page.setCurrent(pageNo);
        page.setSize(pageSize);
        return page;

    }


    @Override
    public List<CharacterVo> checkList(String articleId, String checkResult) {
        return baseMapper.checkList(articleId,checkResult);
    }

    @Override
    public List<CharacterBasicInfo> getListByName(String name) {
        return baseMapper.getListByName(name);
    }

    @Override
    public Integer deduplication(String duty, String company, String name) {
        Integer count = baseMapper.deduplication(duty, company, name);
        return count;
    }

    @Override
    public List<CharacterBasicInfo> getData(String time) {
        LambdaQueryWrapper<CharacterBasicInfo> lambdaQuery = Wrappers.lambdaQuery();
        if(!"".equals(time)){
            lambdaQuery.ge(CharacterBasicInfo::getCreateTime, time);
        }
        lambdaQuery.orderByAsc(CharacterBasicInfo::getCreateTime);
        lambdaQuery.select(CharacterBasicInfo::getUid,CharacterBasicInfo::getName);
        List<CharacterBasicInfo> list = baseMapper.selectList(lambdaQuery);
        return list;
    }

    @Override
    public List<CharacterBasicInfo> getPreviousDuty(String uid) {
        return baseMapper.getPreviousDuty(uid);
    }

    @Override
    public List<String> getCorrelationByUid(String uid) {
        return baseMapper.getCorrelationByUid(uid);
    }

    @Override
    public List<CharacterVo> getByOriginalId(String id) {
        return baseMapper.getByOriginalId(id);
    }

    @Override
    public Result<?> add(CharacterBasicInfo characterBasicInfo) {
        String id = Long.toString(generatorIdService.getOrderId());
        characterBasicInfo.setId(id);
        characterBasicInfo.setCreateTime(new Date());

        String uid = generatorIdService.getIdNo();
        characterBasicInfo.setUid(uid);
        characterBasicInfo.setMainEntry(1);

        Boolean res = this.save(characterBasicInfo);
        return Result.OK(res);
    }

    @Override
    public Result<?> edit(CharacterBasicInfo characterBasicInfo) {
        characterBasicInfo.setUpdateTime(new Date());
        Boolean res = this.updateById(characterBasicInfo);
        return Result.OK(res);
    }

    @Override
    public Boolean del(String id) {
        List<String> ids = Arrays.asList(id.split(","));
        return this.removeByIds(ids);
    }

    @Override
    public Result<?> correlation(CharacterBasicInfo characterBasicInfo) {
        //传过来的id是操作的数据id
        String id = characterBasicInfo.getId();
        if(id == null || "".equals(id))
            return Result.error("id不能为空！");

        String newId = Long.toString(generatorIdService.getOrderId());
        characterBasicInfo.setId(newId);
        characterBasicInfo.setMainEntry(0);
        characterBasicInfo.setCategory("1");
        characterBasicInfo.setCreateTime(new Date());
        Boolean res = this.save(characterBasicInfo);
        return Result.OK(res);
    }

    @Override
    public Result<?> correlationEdit(CharacterBasicInfo characterBasicInfo) {
        characterBasicInfo.setUpdateTime(new Date());
        Boolean res = this.updateById(characterBasicInfo);
        return Result.OK(res);
    }


}
