package com.zzsn.leaderbase.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.leaderbase.entity.CharacterTagMap;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

import java.util.Map;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/21 18:06
 * @Content:
 */
@Mapper
public interface CharacterTagMapMapper extends BaseMapper<CharacterTagMap> {

    @Select("select " +
            "GROUP_CONCAT(a.tag_id SEPARATOR ',') as tag_id, GROUP_CONCAT(b.name SEPARATOR ',') as tag_name " +
            "from character_tag_map a " +
            "LEFT JOIN label_entity b " +
            "on a.tag_id = b.id " +
            "where 1=1 " +
            "and a.character_uid = #{uid}" +
            "group by a.character_uid")
    Map<String, String> getByUid(String uid);

    @Delete("delete from character_tag_map where character_uid = #{uid}")
    void delByUid(String uid);
}
