package com.zzsn.leaderbase.vo;

import lombok.Data;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 17:54
 * @Content:
 */
@Data
public class BasicInfoListVo {

    //当前页码，默认值为1
    private Integer pageNo = 1;

    //分页偏移量 根据 pageNo 和 pageSize 计算得到
    private Integer offset;

    //每页数量，默认值为10
    private Integer pageSize = 10;

    //排序字段，多个排序字段用逗号分隔
    private String column = "id";
    //降序DESC 升序 ASC 默认为DESC
    private String order = "DESC";

    //关键词
    private String keyword;

    //人物名称
    private String name;

    //单位(现)
    private String department;

    //职务(现)
    private String duty;

    //分类类型(1-领导人、2-专家、3-企业高管)
    private String category;

    //类别 左侧树id
    private String typeId;

    //标签
    private String tagId;

    /**
     * 标签信息集合
     */
    private List<LabelVO> labelList;

    //启停状态  1启 0停
    private Long status;
    //审核状态  -1: 黑名单  0:未审核   1:暂定   2:通过
    private String auditStatus;
}
