package com.zzsn.leaderbase.util;

import com.zzsn.leaderbase.service.IGeneratorIdService;
import com.zzsn.leaderbase.vo.CharacterVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/7 11:33
 * @Content: 人物审核时合并操作和取消合并
 */
@Component
public class CharacterMergeStatus {

    /**
     * 生成id
     */
    @Autowired
    IGeneratorIdService generatorIdService;

    /**
     * 根据新老人物信息合并为一个新的人物信息
     * @param originalCharacter
     * @param character
     * @return
     */
    public CharacterVo mergeNew(CharacterVo originalCharacter, CharacterVo character){
        CharacterVo characterVoNew = new CharacterVo();
        String id = Long.toString(generatorIdService.getOrderId());
        characterVoNew.setId(id);
        //人物id使用原人物uid
        String uid = originalCharacter.getUid();
        characterVoNew.setUid(uid);

        characterVoNew.setName(getValue(character.getName(), originalCharacter.getName()));
        characterVoNew.setSex(getValue(character.getSex(), originalCharacter.getSex()));
        characterVoNew.setBirthplace(getValue(character.getBirthplace(), originalCharacter.getBirthplace()));
        characterVoNew.setBirthday(getValue(character.getBirthday(), originalCharacter.getBirthday()));
        characterVoNew.setNativePlace(getValue(character.getNativePlace(), originalCharacter.getNativePlace()));
        characterVoNew.setSchool(getValue(character.getSchool(), originalCharacter.getSchool()));
        characterVoNew.setSpeciality(getValue(character.getSpeciality(), originalCharacter.getSpeciality()));
        characterVoNew.setEducation(getValue(character.getEducation(), originalCharacter.getEducation()));
        characterVoNew.setExpertOccupation(getValue(character.getExpertOccupation(), originalCharacter.getExpertOccupation()));
        characterVoNew.setHeadSculpture(getValue(character.getHeadSculpture(), originalCharacter.getHeadSculpture()));
        characterVoNew.setBiographicalNotes(getValue(character.getBiographicalNotes(), originalCharacter.getBiographicalNotes()));
        characterVoNew.setCategory(getValue(character.getCategory(), originalCharacter.getCategory()));
        characterVoNew.setAwardRecords(getValue(character.getAwardRecords(), originalCharacter.getAwardRecords()));
        characterVoNew.setPartTimeJob(getValue(character.getPartTimeJob(), originalCharacter.getPartTimeJob()));
        characterVoNew.setResearchField(getValue(character.getResearchField(), originalCharacter.getResearchField()));
        characterVoNew.setEvaluate(getValue(character.getEvaluate(), originalCharacter.getEvaluate()));
        characterVoNew.setCreateTime(new Date());
        //原单位、原部门、原职务，新人物中没值去原数据的现
        characterVoNew.setCompanyOriginal(getValue(character.getCompanyOriginal(), originalCharacter.getCompany()));
        characterVoNew.setDepartmentOriginal(getValue(character.getDepartmentOriginal(), originalCharacter.getDepartment()));
        characterVoNew.setDutyOriginal(getValue(character.getDutyOriginal(), originalCharacter.getDuty()));
        //单位、部门、职务 取新人物中的
        characterVoNew.setCompany(character.getCompany());
        characterVoNew.setDepartment(character.getDepartment());
        characterVoNew.setDuty(character.getDuty());
        characterVoNew.setTakeOfficeTime(character.getTakeOfficeTime());
        characterVoNew.setTakeOfficeStatus(character.getTakeOfficeStatus());
        characterVoNew.setChangeUrl(character.getChangeUrl());
        characterVoNew.setDutiesUpdateTime(character.getDutiesUpdateTime());
        characterVoNew.setDutiesUpdateReason(character.getDutiesUpdateReason());
        characterVoNew.setCheckStatus(1L);
        characterVoNew.setCheckResult(character.getCheckResult());
        characterVoNew.setArticleId(character.getArticleId());
        characterVoNew.setArticleTitle(character.getArticleTitle());
        characterVoNew.setUpdateDesc(character.getUpdateDesc());
        characterVoNew.setOriginalId(originalCharacter.getId());
        characterVoNew.setNewId(character.getId());
        characterVoNew.setMergeStatus(1L);

        return characterVoNew;
    }

    /**
     * 若value1不为空则返回value1，否则返回value2
     * @param value1
     * @param value2
     * @return
     */
    private String getValue(String value1, String value2){
        if(value1 == null || value1.length() == 0)
            return value2;
        return value1;
    }
    private Date getValue(Date value1, Date value2){
        if(value1 == null)
            return value2;
        return value1;
    }

    private boolean isNotEmpty(String value){
        return value != null && value.length() > 0;
    }
    private boolean isNotEmpty(Date value){
        return value != null;
    }

    /**
     * 合并两个字段，用 ；分隔
     * @param value1
     * @param value2
     * @return
     */
    private String mergeValue(String value1, String value2){
        StringBuffer sb = new StringBuffer();
        if(value1 == null || value1.length() == 0){
            sb.append(value2);
        } else {
            sb.append(value1).append(";").append(value2);
        }
        return sb.toString();
    }

}
