package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CharacterTag;
import com.zzsn.leaderbase.entity.CharacterTagTop;
import com.zzsn.leaderbase.mapper.CharacterTagMapper;
import com.zzsn.leaderbase.mapper.CharacterTagTopMapper;
import com.zzsn.leaderbase.service.CharacterTagService;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/21 11:04
 * @Content:
 */
@Service
public class CharacterTagServiceImpl extends ServiceImpl<CharacterTagMapper, CharacterTag> implements CharacterTagService {

    @Autowired
    CharacterTagMapper characterTagMapper;

    @Autowired
    CharacterTagTopMapper characterTagTopMapper;


    @Override
    public Result<?> getTagList(String type, String category) {
        return Result.OK(characterTagMapper.getTagList(type, category));
    }


    @Override
    public Result<?> getCharacterListByTag(String tagName, Integer pageNo, Integer pageSize) {
        Integer offset = (pageNo -1) * pageSize;

        List<CharacterTag> tagList = null;
        //根据标签名称查询标签信息
        LambdaQueryWrapper<CharacterTag> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(CharacterTag::getName, tagName);
        tagList = characterTagMapper.selectList(lambdaQuery);
        if(tagList.size() == 0){
            //根据名称如果没有匹配到标签信息，则使用模糊查找
            LambdaQueryWrapper<CharacterTag> lambdaQueryLike = Wrappers.lambdaQuery();
            lambdaQueryLike.like(CharacterTag::getName, tagName);
            tagList = characterTagMapper.selectList(lambdaQueryLike);
            if(tagList.size() == 0){
                //模糊查询也没有数据，直接返回
                return Result.OK("未查询到人物信息！",null);
            }
        }
        List<String> tagIds = new ArrayList<>();
        for (CharacterTag characterTag : tagList) {
            tagIds.add(characterTag.getId());
        }
        //根据标签列表查询人物信息
        String ids = Arrays.toString(tagIds.toArray(new String[0])).replace("[", "(").replace("]", ")");
        List<CharacterVo> list = characterTagMapper.getCharacterListByTagList(ids, offset, pageSize);
        Integer total = characterTagMapper.getCharacterListByTagCount(ids);
        Page page = new Page<>();

        page.setRecords(list);
        page.setTotal(total);
        page.setCurrent(pageNo);
        page.setSize(pageSize);

        //记录查询次数
        this.addTagTop(tagName);

        return Result.OK(page);
    }


    @Override
    public void addTagTop(CharacterTagTop characterTagTop){
        characterTagTopMapper.insert(characterTagTop);
    }

    @Override
    public Result<?> getTopTag() {
        List<String> list = characterTagMapper.getTopTag();
        return Result.OK(list);
    }

    private void addTagTop(String tagName){

        CharacterTagTop characterTagTop = characterTagTopMapper.getByName(tagName);
        if (characterTagTop == null){
            CharacterTagTop newTagTop = new CharacterTagTop();
            newTagTop.setName(tagName);
            newTagTop.setCountNum(1);
            characterTagTopMapper.insert(newTagTop);
        } else {
            characterTagTop.setCountNum(characterTagTop.getCountNum() + 1L);
            characterTagTopMapper.updateById(characterTagTop);
        }


    }

}






