package com.zzsn.leaderbase.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 人物基本信息修改历史记录表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("character_basic_info_history")
public class CharacterBasicInfoHistory extends Model<CharacterBasicInfoHistory> {
  private static final long serialVersionUID = 1L;

  //主键
  @TableId(value = "id", type = IdType.ASSIGN_ID)
  private String id;
  //人物id
  private String uid;
  //人物名称
  private String name;
  //性别
  private String sex;
  //出生地
  private String birthplace;
  //出生日期
  private String birthday;
  //籍贯
  private String nativePlace;
  //毕业院校
  private String school;
  //专业
  private String speciality;
  //学历
  private String education;
  //职业
  private String expertOccupation;
  //头像
  private String headSculpture;
  //个人简历 简介
  private String biographicalNotes;
  //  分类类型:领导人、专家、企业高管
  private String category;
  //  任职经历，每一条任职经历用 （换行）分割
  private String awardRecords;
  //  社会兼职，每一条用 （换行） 分割
  private String partTimeJob;
  //研究领域
  private String researchField;
  //荣誉评价
  private String evaluate;
  //创建人
  private String createBy;
  //创建时间
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  //更新人
  private String updateBy;
  //更新时间
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date updateTime;
  //启停状态  1启 0停
  private Long status;


}
