package com.zzsn.leaderbase.controller;


import com.zzsn.leaderbase.entity.CharacterCategoryStructure;
import com.zzsn.leaderbase.service.LeaderCategoryService;
import com.zzsn.leaderbase.vo.Result;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 *  分类树前端控制器
 * </p>
 *
 * @author obcy
 * @since 2024-02-27
 */
@RestController
@RequestMapping("/api/category")
public class LeaderCategoryController {
    @Autowired
    LeaderCategoryService leaderCategoryService;

    /**
     * 根据id查询分类树
     * */
    @GetMapping
    public Result<?> getById(@RequestParam(name="id",required=true) String id){
        return Result.OK(leaderCategoryService.getById(id));
    }

    /**
     * 新增分类树
     */
    @PostMapping("/add")
    public Result<?> add(@RequestBody CharacterCategoryStructure characterCategoryStructure){
       return leaderCategoryService.add(characterCategoryStructure);
    }
    /**
     * 编辑分类树
     * */
    @PostMapping("/edit")
    public Result<?> edit(@RequestBody CharacterCategoryStructure characterCategoryStructure){
       return leaderCategoryService.edit(characterCategoryStructure);
    }

    /**
     * 删除分类树
     * */
    @GetMapping("/del")
    public Result<?> del(@RequestParam(name="id",required=true) String id){
       return leaderCategoryService.del(id);
    }

    /**
     * 查询分类树列表
     * @param sign
     * @param category
     * @param pid
     * @param httpServletRequest
     * @return
     */
    @GetMapping("/list")
    public Result<?> list(
            @RequestParam(name="sign",defaultValue = "1") String sign,
            @RequestParam(name="category",required = false) String category,
            @RequestParam(name="pid",defaultValue = "0") String pid,
            HttpServletRequest httpServletRequest
                          ){
        if (!"1".equals(sign)){
            if (StringUtils.isBlank(pid)){
                return Result.error("查询非顶级节点列表时需要pid参数");
            }
        }
        return  leaderCategoryService.lists(sign,pid,category);

    }


    /**
     * 根据名称模糊查询所有节点及父节点
     * @param category
     * @param typeName
     * @return
     */
    @GetMapping("/getByName")
    public Result<?> getByName(
            @RequestParam(name="category",required = false) String category,
            @RequestParam(name="typeName",required=false) String typeName){

        if(typeName == null || "".equals(typeName)){
            //查询全部数据封装成树
            return leaderCategoryService.getAll(category);
        } else {
            //根据typeName模糊查询节点和父节点
            return leaderCategoryService.getByName(category,typeName);
        }
    }


//    @GetMapping("/type")
//    public Result<?> type(){
//        return Result.OK(KnowTypeEnum.getAllAsMap());
//    }

}
