package com.zzsn.leaderbase.controller;

import com.zzsn.leaderbase.service.CharacterDetailsService;
import com.zzsn.leaderbase.service.CorrelationEnterpriseService;
import com.zzsn.leaderbase.service.LearningAchievementService;
import com.zzsn.leaderbase.service.impl.CisXgraPaperServiceImpl;
import com.zzsn.leaderbase.vo.DetailsListVo;
import com.zzsn.leaderbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/4 14:18
 * @Content:
 */
@RestController
@RequestMapping("/api/detail")
public class CharacterDetailsController {

    //重要讲话 相关报道查询
    @Autowired
    CharacterDetailsService characterDetailsService;

    //学术信息
    @Autowired
    CisXgraPaperServiceImpl cisXgraPaperService;

    //学术成果
    @Autowired
    LearningAchievementService learningAchievementService;

    //企业信息
    @Autowired
    CorrelationEnterpriseService correlationEnterpriseService;

    /**
     * 重要讲话 相关报道查询
     * @param detailsListVo
     * @return
     */
    @PostMapping("/informationList")
    public Result<?> informationList(@RequestBody DetailsListVo detailsListVo){

        String uid = detailsListVo.getUid();
        if(uid == null || "".equals(uid))
            return Result.error("人物id不能为空！");
        Long type = detailsListVo.getType();
        if(type == null)
            return Result.error("类型type不能为空！");

        Integer pageNo = detailsListVo.getPageNo();
        Integer pageSize= detailsListVo.getPageSize();
        if(pageNo < 1)
            return Result.error("参数pageNo的值不能小于1！");
        if(pageSize < 0)
            return Result.error("参数pageSize的值不能小于0！");
        Integer office = pageSize * (pageNo - 1);
        detailsListVo.setOffset(office);

        return characterDetailsService.informationList(detailsListVo);
    }

    /**
     * 根据关联咨询索引和id查询咨询详情
     * @param index 关联咨询所在es索引
     * @param id 关联咨询es id
     * @return
     */
    @GetMapping("/getInformation")
    public Result<?> getInformation(
            @RequestParam(name="index",required=true) String index,
            @RequestParam(name="id",required=true) String id
    ){

        if(index == null || "".equals(index))
            return Result.error("索引名称不能为空");
        if(id == null || "".equals(id))
            return Result.error("id不能为空！");

        return characterDetailsService.getInformation(index, id);
    }

    /**
     * 学术信息查询
     * 根据人物uid
     * @param uid
     * @return
     */
    @GetMapping("/getCisXgraPaper")
    public Result<?> getCisXgraPaper(@RequestParam(name="uid",required=true) String uid){
        if(uid == null || "".equals(uid))
            Result.error("人物id不能为空！");
        return cisXgraPaperService.getCisXgraPaper(uid);
    }


    /**
     * 学术成果查询
     * @param detailsListVo
     * @return
     */
    @PostMapping("/getLearningAchievementList")
    public Result<?> getLearningAchievementList(@RequestBody DetailsListVo detailsListVo){
        String uid = detailsListVo.getUid();
        if(uid == null || "".equals(uid))
            return Result.error("人物id不能为空！");

        Integer pageNo = detailsListVo.getPageNo();
        Integer pageSize= detailsListVo.getPageSize();
        if(pageNo < 1)
            return Result.error("参数pageNo的值不能小于1！");
        if(pageSize < 0)
            return Result.error("参数pageSize的值不能小于0！");
        Integer office = pageSize * (pageNo - 1);
        detailsListVo.setOffset(office);

        return learningAchievementService.getLearningAchievementList(detailsListVo);
    }


    /**
     * CorrelationEnterprise
     * 相关企业查询
     * @param detailsListVo
     * @return
     */
    @PostMapping("/getCorrelationEnterpriseList")
    public Result<?> getCorrelationEnterpriseList(@RequestBody DetailsListVo detailsListVo) {
        String uid = detailsListVo.getUid();
        if (uid == null || "".equals(uid))
            return Result.error("人物id不能为空！");

        Integer pageNo = detailsListVo.getPageNo();
        Integer pageSize = detailsListVo.getPageSize();
        if (pageNo < 1)
            return Result.error("参数pageNo的值不能小于1！");
        if (pageSize < 0)
            return Result.error("参数pageSize的值不能小于0！");
        Integer office = pageSize * (pageNo - 1);
        detailsListVo.setOffset(office);

        return correlationEnterpriseService.getCorrelationEnterpriseList(detailsListVo);
    }
}
