package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.entity.CharacterBasicInfoHistory;
import com.zzsn.leaderbase.entity.CharacterChangeInfo;
import com.zzsn.leaderbase.service.*;
import com.zzsn.leaderbase.vo.CharacterListVo;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.Result;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:13
 * @Content: 人物基本信息和职务变更信息
 */
@Service
public class CharacterInfoServiceImpl implements CharacterInfoService {

    @Autowired
    CharacterBasicInfoService characterBasicInfoService;
    @Autowired
    CharacterBasicInfoHistoryService characterBasicInfoHistoryService;

    @Autowired
    CharacterChangeInfoService characterChangeInfoService;
    @Autowired
    CharacterChangeInfoHistoryService characterChangeInfoHistoryService;

    /**
     * 雪花算法生成id
     */
    @Autowired
    IGeneratorIdService generatorIdService;


    @Override
    public Result<?> add(CharacterVo characterVo) {

        String id = Long.toString(generatorIdService.getOrderId());
        //vo对象获取转entity对象，基本信息
        CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
        BeanUtils.copyProperties(characterVo, characterBasicInfo);
        characterBasicInfo.setId(id);
        characterBasicInfoService.save(characterBasicInfo);

        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(characterVo, characterChangeInfo);
        characterChangeInfo.setId(id);
        characterChangeInfoService.save(characterChangeInfo);

        //记录任务基本信息修改记录
        CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
        BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
        characterBasicInfoHistory.setId(null);
        characterBasicInfoHistoryService.save(characterBasicInfoHistory);

        return Result.OK();
    }

    @Override
    public CharacterVo getByUid(String uid) {
        return characterBasicInfoService.getByUid(uid);
    }

    @Override
    public CharacterVo getById(String id) {
        return characterBasicInfoService.getById(id);
    }

    @Override
    public Result<?> edit(CharacterVo characterVo) {
        //vo对象获取转entity对象，基本信息
        CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
        BeanUtils.copyProperties(characterVo, characterBasicInfo);
        characterBasicInfoService.updateById(characterBasicInfo);

        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(characterVo, characterChangeInfo);
        characterChangeInfoService.updateById(characterChangeInfo);

        //记录任务基本信息修改记录
        CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
        BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
        characterBasicInfoHistory.setId(null);
        characterBasicInfoHistoryService.save(characterBasicInfoHistory);

        return Result.OK();
    }

    @Override
    public IPage<CharacterVo> list(CharacterListVo characterListVo) {
        QueryWrapper<CharacterVo> queryWrapper = new QueryWrapper<>();
        //queryWrapper.eq("name","王强").leftJoin("")



        return null;
    }
}
