package com.zzsn.leaderbase.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.vo.CharacterVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:36
 * @Content:
 */
@Mapper
public interface CharacterBasicInfoMapper extends BaseMapper<CharacterBasicInfo> {

    @Select("select " +
            "a.id,a.uid,a.name,a.sex,a.birthplace,a.birthday,a.native_place,a.school,a.speciality,a.education,a.expert_occupation,a.head_sculpture,a.biographical_notes,a.category,a.award_records,a.part_time_job,a.research_field,a.evaluate,a.create_by,a.create_time,a.update_by,a.update_time,a.status,department_original,duty_original,department,duty,b.take_office_time,b.take_office_status,b.change_url,b.duties_update_time,b.duties_update_reason,b.check_status,b.check_result,b.article_id,b.article_title,b.update_desc " +
            "from character_basic_info a " +
            "LEFT JOIN character_change_info b " +
            "on a.id = b.id " +
            "where a.uid = #{uid}")
    CharacterVo getByUid(String uid);

    @Select("select " +
            "a.id,a.uid,a.name,a.sex,a.birthplace,a.birthday,a.native_place,a.school,a.speciality,a.education,a.expert_occupation,a.head_sculpture,a.biographical_notes,a.category,a.award_records,a.part_time_job,a.research_field,a.evaluate,a.create_by,a.create_time,a.update_by,a.update_time,a.status,department_original,duty_original,department,duty,b.take_office_time,b.take_office_status,b.change_url,b.duties_update_time,b.duties_update_reason,b.check_status,b.check_result,b.article_id,b.article_title,b.update_desc " +
            "from character_basic_info a " +
            "LEFT JOIN character_change_info b " +
            "on a.id = b.id " +
            "where a.id = #{id}")
    CharacterVo getById(String id);
}
