package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.LearningAchievement;
import com.zzsn.leaderbase.mapper.LearningAchievementMapper;
import com.zzsn.leaderbase.service.LearningAchievementService;
import com.zzsn.leaderbase.vo.DetailsListVo;
import com.zzsn.leaderbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/5 15:18
 * @Content:
 */
@Service
public class LearningAchievementServiceImpl extends ServiceImpl<LearningAchievementMapper, LearningAchievement> implements LearningAchievementService {

    @Autowired
    LearningAchievementMapper learningAchievementMapper;

    @Override
    public Result<?> getLearningAchievementList(DetailsListVo detailsListVo) {
        String uid = detailsListVo.getUid();

        LambdaQueryWrapper<LearningAchievement> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(LearningAchievement::getUid, uid);
        lambdaQuery.orderByDesc(LearningAchievement::getPublishData);

        StringBuffer sb = new StringBuffer()
                .append(" limit ")
                .append(detailsListVo.getOffset())
                .append(",")
                .append(detailsListVo.getPageSize());
        lambdaQuery.last(sb.toString());
        List<LearningAchievement> list = learningAchievementMapper.selectList(lambdaQuery);

        IPage page = new Page();
        page.setRecords(list);

        Integer total = learningAchievementMapper.selectCount(lambdaQuery);
        page.setTotal(total);
        page.setCurrent(detailsListVo.getPageNo());
        page.setSize(detailsListVo.getPageSize());

        return Result.OK(page);
    }
}
