/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZWQ;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzT;
import com.aspose.words.net.System.Data.zzU;
import com.aspose.words.net.System.Data.zzX;
import com.aspose.words.net.System.Data.zzY;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzXtD;
    private final DataColumnCollection zzXtC;
    private final ConstraintCollection zzXtB;
    private final zzT zzXtA;
    private ResultSet zzXtz;
    private String zzYXQ;
    private DataSet zz2p;
    private String zzYN7;
    private UniqueConstraint zzXty;
    private boolean zzXtL;
    private final List<DataTableEventListener> zzXtx;
    private final Set<DataRow> zzXtw;

    public DataTable() {
        this.zzXtD = new DataRowCollection(this);
        this.zzXtC = new DataColumnCollection(this);
        this.zzXtB = new ConstraintCollection(this);
        this.zzXtA = new zzT(this);
        this.zzYN7 = "";
        this.zzXtL = true;
        this.zzXtx = new ArrayList<DataTableEventListener>();
        this.zzXtw = new HashSet<DataRow>();
    }

    public DataTable(String tableName) {
        this.zzXtD = new DataRowCollection(this);
        this.zzXtC = new DataColumnCollection(this);
        this.zzXtB = new ConstraintCollection(this);
        this.zzXtA = new zzT(this);
        this.zzYN7 = "";
        this.zzXtL = true;
        this.zzXtx = new ArrayList<DataTableEventListener>();
        this.zzXtw = new HashSet<DataRow>();
        this.zzYXQ = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzY.zzZ(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzXtD = new DataRowCollection(this);
        this.zzXtC = new DataColumnCollection(this);
        this.zzXtB = new ConstraintCollection(this);
        this.zzXtA = new zzT(this);
        this.zzYN7 = "";
        this.zzXtL = true;
        this.zzXtx = new ArrayList<DataTableEventListener>();
        this.zzXtw = new HashSet<DataRow>();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzXtz = resultSet;
        this.zzYXQ = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzXtz != null) {
            if (this.zzXtz.getStatement() != null) {
                this.zzXtz.getStatement().getConnection().close();
            }
            this.zzXtz = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzYXQ;
    }

    public void setTableName(String tableName) {
        this.zzYXQ = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXtC.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXtC.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzXtz;
    }

    public DataSet getDataSet() {
        return this.zz2p;
    }

    final void zzW(DataSet dataSet) {
        this.zz2p = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zz2p.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zz2p.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzXtD;
    }

    public DataColumnCollection getColumns() {
        return this.zzXtC;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXtB;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzXty == null) {
            return new DataColumn[0];
        }
        return this.zzXty.getColumns();
    }

    final void zzT(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzXty != null) {
                this.zzXty.zzOv(false);
                this.getConstraints().remove(this.zzXty);
                this.zzXty = null;
            }
            return;
        }
        if (this.zzXty != null && DataColumn.areColumnSetsTheSame(value, this.zzXty.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzZ(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzXty != null) {
            this.zzXty.zzOv(false);
            this.getConstraints().remove(this.zzXty);
            this.zzXty = null;
        }
        UniqueConstraint.zzZ(this.getConstraints(), uniqueConstraint);
        this.zzXty = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzYN7;
    }

    public void setNamespace(String namespace) {
        this.zzYN7 = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXtL;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXtL = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzXtw.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzY.zzZ(this.getResultSet(), this);
            zzY.zzY(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzZWQ.zzW(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzY.zzX(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXtx.contains(listener)) {
            this.zzXtx.add(listener);
        }
    }

    public void removeEventListener(zzX listener) {
        if (this.zzXtx.contains(listener)) {
            this.zzXtx.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXtx.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzXtw.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXtx) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzXtw.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXtx) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzXtw.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXtx) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXtx) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXtx) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzU zzZ(zzY[] zzYArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzYArray.length];
        for (int i = 0; i < zzYArray.length; ++i) {
            dataColumnArray[i] = zzYArray[i].zzYbC();
        }
        DataTable dataTable = this;
        zzU zzU10 = dataTable.zzXtA.zzW(dataColumnArray);
        if (zzU10 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzU10;
    }

    final zzT zzYbB() {
        return this.zzXtA;
    }

    final Set<DataRow> zzYbA() {
        return this.zzXtw;
    }
}

