/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zz07;
import com.aspose.words.internal.zz0R;
import com.aspose.words.internal.zz0T;
import com.aspose.words.internal.zz0W;
import com.aspose.words.internal.zz2B;
import com.aspose.words.internal.zz2D;
import com.aspose.words.internal.zzZTB;
import com.aspose.words.internal.zzZWQ;
import com.aspose.words.internal.zzZY8;
import com.aspose.words.internal.zzZYM;
import com.aspose.words.internal.zzZYY;
import com.aspose.words.internal.zzZZF;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.DataTableCollection;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.XmlReadMode;
import com.aspose.words.net.System.Data.zzS;
import com.aspose.words.net.System.Data.zzW;
import com.aspose.words.net.System.Data.zzY;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DataSet {
    private boolean zzXtL = true;
    private String zzXtK = "NewDataSet";
    private Locale zzcE;
    private DataTableCollection zzXtJ = new DataTableCollection(this);
    private DataRelationCollection zzXtI = new DataRelationCollection();
    private String zzXtH;

    public DataSet() {
    }

    public DataSet(Connection connection) throws Exception {
        this(connection, "");
    }

    public DataSet(Connection connection, String schemaName) throws Exception {
        Object object;
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = connection.getCatalog();
        List<String> list = zzY.zzZ(databaseMetaData, schemaName, string);
        for (String object22 : list) {
            object = zzY.zzYf(schemaName, object22);
            ResultSet resultSet = connection.createStatement().executeQuery("SELECT * FROM " + (String)object);
            DataTable dataTable = new DataTable(resultSet, object22);
            dataTable.zzT(zzY.zzZ(databaseMetaData, string, schemaName, object22));
            this.getTables().add(dataTable);
            zzY.zzZ(databaseMetaData, string, schemaName, dataTable);
        }
        List<DataRelation> list2 = zzY.zzZ(databaseMetaData, string, schemaName, this.getTables());
        Iterator<DataRelation> iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.getRelations().add((DataRelation)object);
        }
    }

    public DataSet(String name) {
        this.zzXtK = name;
    }

    public String getDataSetName() {
        return this.zzXtK;
    }

    public void setDataSetName(String newDataSetName) {
        this.zzXtK = newDataSetName;
    }

    public String getNamespace() {
        return null;
    }

    public DataTableCollection getTables() {
        return this.zzXtJ;
    }

    public DataRelationCollection getRelations() {
        return this.zzXtI;
    }

    public void close() throws Exception {
        for (DataTable dataTable : this.zzXtJ) {
            dataTable.close();
        }
    }

    public void clear() {
        for (DataTable dataTable : this.getTables()) {
            dataTable.getRows().clear();
        }
    }

    public void reset() {
        this.clear();
        Iterator<DataTable> iterator = this.zzXtJ.iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
        Iterator<DataRelation> iterator2 = this.zzXtI.iterator();
        while (iterator2.hasNext()) {
            iterator2.remove();
        }
    }

    public XmlReadMode readXml(InputStream xmlStream, XmlReadMode mode) throws DataException {
        if (xmlStream == null) {
            return mode;
        }
        boolean bl = false;
        try {
            zzZTB zzZTB2 = DataSet.zzYbD();
            XMLStreamReader xMLStreamReader = zzZTB2.createXMLStreamReader(xmlStream);
            zzW zzW10 = null;
            zz0T zz0T2 = null;
            if (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.next()) {
                    case 1: {
                        if (xMLStreamReader.getLocalName().equals("diffgram") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-diffgram-v1")) {
                            switch (mode) {
                                case AUTO: 
                                case DIFF_GRAM: {
                                    zzW10 = new zzW(this);
                                    zzW10.zzb(xMLStreamReader);
                                    return XmlReadMode.DIFF_GRAM;
                                }
                                case FRAGMENT: {
                                    DataSet.zze(xMLStreamReader);
                                    break;
                                }
                                default: {
                                    DataSet.zze(xMLStreamReader);
                                    return mode;
                                }
                            }
                        }
                        if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data") || xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                            bl = true;
                            switch (mode) {
                                case IGNORE_SCHEMA: 
                                case INFER_SCHEMA: {
                                    DataSet.zze(xMLStreamReader);
                                    return mode;
                                }
                                case FRAGMENT: {
                                    this.zzd(xMLStreamReader);
                                    break;
                                }
                                case AUTO: {
                                    if (this.getTables().getCount() == 0) {
                                        this.zzd(xMLStreamReader);
                                        return XmlReadMode.READ_SCHEMA;
                                    }
                                    DataSet.zze(xMLStreamReader);
                                    return XmlReadMode.IGNORE_SCHEMA;
                                }
                                default: {
                                    this.zzd(xMLStreamReader);
                                    return mode;
                                }
                            }
                        }
                        zz0T2 = new zz0T();
                        zz0T2.setName(zz0W.zzVj(xMLStreamReader.getLocalName()));
                        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
                            if (!"".equals(xMLStreamReader.getAttributePrefix(i))) continue;
                            zz0T2.zzmG().put(xMLStreamReader.getAttributeLocalName(i), xMLStreamReader.getAttributeValue(i));
                        }
                        break;
                    }
                }
            }
            XmlReadMode xmlReadMode = mode;
            while (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.next()) {
                    case 1: {
                        zzS zzS10;
                        if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data") || xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                            xMLStreamReader.getLocalName().equals("Schema");
                            switch (mode) {
                                case IGNORE_SCHEMA: 
                                case INFER_SCHEMA: {
                                    DataSet.zze(xMLStreamReader);
                                    break;
                                }
                                default: {
                                    this.zzd(xMLStreamReader);
                                    xmlReadMode = XmlReadMode.READ_SCHEMA;
                                    bl = true;
                                    break;
                                }
                            }
                            break;
                        }
                        if (xMLStreamReader.getLocalName().equals("diffgram") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-diffgram-v1")) {
                            if (mode == XmlReadMode.DIFF_GRAM || mode == XmlReadMode.IGNORE_SCHEMA || mode == XmlReadMode.AUTO) {
                                if (zzW10 == null) {
                                    zzW10 = new zzW(this);
                                }
                                zzW10.zzb(xMLStreamReader);
                                xmlReadMode = XmlReadMode.DIFF_GRAM;
                                if (mode != XmlReadMode.DIFF_GRAM) break;
                                return xmlReadMode;
                            }
                            DataSet.zze(xMLStreamReader);
                            break;
                        }
                        if (!(bl || xmlReadMode == XmlReadMode.READ_SCHEMA || mode == XmlReadMode.IGNORE_SCHEMA || mode == XmlReadMode.FRAGMENT || this.getTables().getCount() != 0 && mode != XmlReadMode.INFER_SCHEMA)) {
                            if (mode == XmlReadMode.AUTO) {
                                xmlReadMode = XmlReadMode.INFER_SCHEMA;
                            }
                            zzS10 = new zzS(this, xMLStreamReader, zz0T2, true);
                            zzS10.zzYbi();
                            return xmlReadMode;
                        }
                        mode = bl ? XmlReadMode.READ_SCHEMA : XmlReadMode.IGNORE_SCHEMA;
                        zzS10 = new zzS(this, xMLStreamReader, zz0T2, false);
                        zzS10.zzYbi();
                    }
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DataException(xMLStreamException);
        }
        catch (SQLException sQLException) {
            throw new DataException(sQLException);
        }
        catch (zz07 zz072) {
            throw new DataException(zz072);
        }
        catch (InvalidConstraintException invalidConstraintException) {
            throw new DataException(invalidConstraintException);
        }
        return XmlReadMode.AUTO;
    }

    public XmlReadMode readXml(zz2B xmlStream) throws DataException {
        return this.readXml(zz2B.zzZU(xmlStream));
    }

    public XmlReadMode readXml(InputStream xmlStream) throws DataException {
        return this.readXml(xmlStream, XmlReadMode.AUTO);
    }

    public XmlReadMode readXml(String xmlPath) throws DataException {
        return this.readXml(xmlPath, XmlReadMode.AUTO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlReadMode readXml(String xmlPath, XmlReadMode readMode) throws DataException {
        XmlReadMode xmlReadMode;
        if (xmlPath == null) throw new IllegalArgumentException("xmlPath cannot be empty");
        if (xmlPath.trim().length() == 0) {
            throw new IllegalArgumentException("xmlPath cannot be empty");
        }
        InputStream inputStream = null;
        try {
            this.zzXtH = xmlPath;
            inputStream = new FileInputStream(xmlPath);
            xmlReadMode = this.readXml(inputStream, readMode);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new DataException(fileNotFoundException);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    Exception exception3 = exception;
                    zzZWQ.zzX(exception);
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return xmlReadMode;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            zzZWQ.zzX(exception);
        }
        return xmlReadMode;
    }

    @Deprecated
    public XmlReadMode readXml(zz2D stream) {
        return this.readXml(new zzZY8(stream));
    }

    public void readXmlSchema(zz2B xmlStream) throws DataException {
        this.readXmlSchema(zz2B.zzZU(xmlStream));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readXmlSchema(InputStream xmlStream) throws DataException {
        if (xmlStream == null) {
            throw new IllegalArgumentException("xmlStream cannot be null");
        }
        XMLStreamReader xMLStreamReader = null;
        try {
            zzZTB zzZTB2 = DataSet.zzYbD();
            xMLStreamReader = zzZTB2.createXMLStreamReader(xmlStream);
            this.zzd(xMLStreamReader);
            if (xMLStreamReader == null) return;
        }
        catch (XMLStreamException xMLStreamException) {
            try {
                throw new DataException(xMLStreamException);
                catch (zz07 zz072) {
                    throw new DataException(zz072);
                }
                catch (InvalidConstraintException invalidConstraintException) {
                    throw new DataException(invalidConstraintException);
                }
            }
            catch (Throwable throwable) {
                if (xMLStreamReader == null) throw throwable;
                try {
                    xMLStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException xMLStreamException2) {
                    throw new DataException(xMLStreamException2);
                }
            }
        }
        try {
            xMLStreamReader.close();
            return;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DataException(xMLStreamException);
        }
    }

    public void readXmlSchema(String xmlPath) throws DataException {
        if (xmlPath == null || xmlPath.trim().length() == 0) {
            throw new IllegalArgumentException("xmlPath cannot be empty");
        }
        InputStream inputStream = null;
        try {
            this.zzXtH = xmlPath;
            try {
                inputStream = new FileInputStream(xmlPath);
                this.readXmlSchema(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new DataException(fileNotFoundException);
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    zzZWQ.zzX(exception);
                }
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            Exception exception3 = exception;
            zzZWQ.zzX(exception);
            return;
        }
    }

    public void setLocale(Locale locale) {
        this.zzcE = locale;
    }

    public boolean isLocaleSpecified() {
        return this.zzcE != null;
    }

    public boolean getEnforceConstraints() {
        return this.zzXtL;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXtL = enforceConstraints;
        for (DataTable dataTable : this.getTables()) {
            dataTable.setEnforceConstraints(enforceConstraints);
        }
    }

    private static void zze(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        String string = xMLStreamReader.getLocalName();
        while (xMLStreamReader.hasNext()) {
            switch (xMLStreamReader.next()) {
                case 2: {
                    if (!string.equals(xMLStreamReader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void zzd(XMLStreamReader xMLStreamReader) throws zz07, XMLStreamException, DataException, InvalidConstraintException {
        int n = 0;
        boolean bl = false;
        do {
            switch (xMLStreamReader.getEventType()) {
                case 1: {
                    if (bl) {
                        ++n;
                    }
                    if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data")) {
                        DataSet.zzYbE();
                        return;
                    }
                    if (xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        this.zzc(xMLStreamReader);
                        return;
                    }
                    if (xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().startsWith("http://www.w3.org/")) {
                        throw new IllegalStateException("DataSetUnsupportedSchema http://www.w3.org/2001/XMLSchema");
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    bl = zzZYM.zzUT(xMLStreamReader.getText().trim());
                    break;
                }
                case 2: {
                    if (--n > 0) break;
                    return;
                }
            }
            if (!xMLStreamReader.hasNext()) continue;
            xMLStreamReader.next();
        } while (xMLStreamReader.hasNext());
    }

    private void zzc(XMLStreamReader xMLStreamReader) throws zz07, XMLStreamException, InvalidConstraintException, DataException {
        zzZZF zzZZF2 = new zzZZF();
        zz0R zz0R2 = zz0R.zzZ(xMLStreamReader);
        zz0R2.zzVe(this.zzXtH);
        zzZZF2.zzN(zz0R2);
        zzZZF2.zzlu();
        zzZYY zzZYY2 = new zzZYY();
        zzZYY2.zzZ(zzZZF2, this);
    }

    private static void zzYbE() {
        throw new UnsupportedOperationException("readXDSSchema is not implemented yet.");
    }

    private static zzZTB zzYbD() {
        zzZTB zzZTB2 = new zzZTB();
        zzZTB2.zzY7z().zzOi(false);
        zzZTB2.zzY7z().zzOr(false);
        zzZTB2.zzY7z().zzOs(false);
        zzZTB2.zzY7z().zzOt(true);
        zzZTB2.zzY7z().zzOu(true);
        zzZTB2.zzY7z().zzOq(false);
        zzZTB2.zzY7z().zzOh(false);
        zzZTB2.zzY7z().zzkq(0x800000);
        return zzZTB2;
    }
}

