/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZYM;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzYEq = new ArrayList();
    private final Map<String, DataColumn> zzXu2 = new HashMap<String, DataColumn>();
    private DataTable zzYtR;

    DataColumnCollection(DataTable table) {
        this.zzYtR = table;
    }

    public void add(DataColumn column) {
        if (zzZYM.zzUT(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzH(column.getColumnName());
        if (this.zzXu2.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzY(this.zzYtR);
        column.setOrdinal(this.zzYEq.size());
        this.zzYEq.add(column);
        this.zzXu2.put(string, column);
        this.zzYtR.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYtR);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzZYM.zzUT(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzH(columnName);
        DataColumn dataColumn = this.zzXu2.get(string);
        if (dataColumn != null) {
            int n = this.zzYEq.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzYEq.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzYEq.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzYEq.remove(n);
            this.zzXu2.remove(DataColumnCollection.zzH(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzYtR.getRows()) {
                dataRow.remove(n);
            }
            this.zzYtR.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzYEq.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzYEq.iterator();
    }

    public void clear() {
        this.zzXu2.clear();
        this.zzYEq.clear();
    }

    final DataColumn[] zzYbL() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzYEq);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzZ(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzYEq.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzYEq.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzH(string);
            String string3 = DataColumnCollection.zzH(dataColumn.getColumnName());
            this.zzXu2.remove(string3);
            this.zzXu2.put(string2, dataColumn);
            return;
        }
    }

    private static String zzH(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

