/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzZ3T;
import com.aspose.words.internal.zzZ4H;
import com.aspose.words.internal.zzZ4J;
import com.aspose.words.internal.zzZ4K;
import com.aspose.words.internal.zzZ52;
import com.aspose.words.internal.zzZ5H;
import com.aspose.words.internal.zzZ5I;
import com.aspose.words.internal.zzZ5J;
import com.aspose.words.internal.zzZLG;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzZ3U
extends CertPathBuilderSpi {
    private final zzZ4K zzWEC;
    private zzZ52 zzWCy;

    zzZ3U(zzZ4K zzZ4K2) {
        this.zzWEC = zzZ4K2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzZ5H pkixParams;
        if (params instanceof zzZ5H) {
            pkixParams = (zzZ5H)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzZ5H.zzZ((PKIXBuilderParameters)params).zzXWq();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzZ5H.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzZ5I zzZ5I2 = pkixParams.zzXWt().zzXWj();
        try {
            collection = zzZ4J.zzZ(zzZ5I2, pkixParams.zzXWt().zzXWp());
            collection.addAll(zzZ4J.zzZ(zzZ5I2, pkixParams.zzXWt().zzXWb()));
        }
        catch (zzZ52 zzZ522) {
            throw new CertPathBuilderException("Error finding target certificate.", zzZ522);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzZ(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzWCy != null) {
            throw new CertPathBuilderException(this.zzWCy.getMessage(), this.zzWCy.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzZ(X509Certificate x509Certificate, zzZ5H zzZ5H2, List list) throws CertPathBuilderException {
        zzZ3T zzZ3T2;
        zzZ4H zzZ4H2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzZ5H2.zzXWs().contains(x509Certificate)) {
            return null;
        }
        if (zzZ5H2.zzXWr() != -1 && list.size() - 1 > zzZ5H2.zzXWr()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzZ4H2 = new zzZ4H(this.zzWEC);
            zzZ3T2 = new zzZ3T(this.zzWEC);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzZ4J.zzZ(x509Certificate, zzZ5H2.zzXWt().zzXWi(), zzZ5H2.zzXWt().zzXWg()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzZ4H2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzZ52("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzZ3T2.engineValidate(certPath, zzZ5H2);
                }
                catch (Exception exception) {
                    throw new zzZ52("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzZ5J> arrayList = new ArrayList<zzZ5J>();
            arrayList.addAll(zzZ5H2.zzXWt().zzXWp());
            try {
                arrayList.addAll(zzZ4J.zzZ(x509Certificate.getExtensionValue(zzZLG.zzX6H.getId()), zzZ5H2.zzXWt().zzXWo()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzZ52("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzZ4J.zzZ(x509Certificate, zzZ5H2.zzXWt().zzXWb(), arrayList));
            }
            catch (zzZ52 zzZ522) {
                throw new zzZ52("Cannot find issuer certificate for certificate in certification path.", zzZ522);
            }
            if (hashSet.isEmpty()) {
                throw new zzZ52("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzZ(x509Certificate2, zzZ5H2, list);
            }
        }
        catch (zzZ52 zzZ523) {
            this.zzWCy = zzZ523;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

