/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzYVP;
import com.aspose.words.internal.zzYVV;
import com.aspose.words.internal.zzZ1Q;
import com.aspose.words.internal.zzZ1U;
import com.aspose.words.internal.zzZ1Z;
import com.aspose.words.internal.zzZKX;
import com.aspose.words.internal.zzZKY;
import com.aspose.words.internal.zzZL9;
import com.aspose.words.internal.zzZLC;
import com.aspose.words.internal.zzZLF;
import com.aspose.words.internal.zzZLG;
import com.aspose.words.internal.zzZLL;
import com.aspose.words.internal.zzZLO;
import com.aspose.words.internal.zzZLP;
import com.aspose.words.internal.zzZLX;
import com.aspose.words.internal.zzZM0;
import com.aspose.words.internal.zzZQP;
import com.aspose.words.internal.zzZQT;
import com.aspose.words.internal.zzZQU;
import com.aspose.words.internal.zzZQV;
import com.aspose.words.internal.zzZQX;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class zzZ1T
extends X509CRL {
    private final Provider zzWCx;
    private final zzZLL zzWyR;
    private final String zzWyQ;
    private final byte[] zzWyP;
    private final boolean zzWyO;
    private volatile boolean zzX6Q = false;
    private volatile int zzX8r;

    static boolean zzX(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(zzZLG.zzX6C.getId());
            return byArray != null && zzZL9.zzXj(zzZQT.zzYM(byArray).zzY5V()).zzY2w();
        }
        catch (Exception exception) {
            throw new CRLException("Exception reading IssuingDistributionPoint", exception);
        }
    }

    protected zzZ1T(Provider provider, zzZLL zzZLL2) throws CRLException {
        this.zzWCx = provider;
        this.zzWyR = zzZLL2;
        try {
            this.zzWyQ = zzZ1Q.zzR(zzZLL2.zzY2R());
            this.zzWyP = (byte[])(zzZLL2.zzY2R().zzY40() != null ? zzZLL2.zzY2R().zzY40().zzY5Q().getEncoded("DER") : null);
            this.zzWyO = zzZ1T.zzX(this);
            return;
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.removeAll(zzZ1Z.zzWz2);
        return !set.isEmpty();
    }

    private Set zzNn(boolean bl) {
        zzZLF zzZLF2;
        if (this.getVersion() == 2 && (zzZLF2 = this.zzWyR.zzY2P().zzY3p()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = zzZLF2.zzY2C();
            while (enumeration.hasMoreElements()) {
                zzZQU zzZQU2 = (zzZQU)enumeration.nextElement();
                zzZLG zzZLG2 = zzZLF2.zzS(zzZQU2);
                if (bl != zzZLG2.isCritical()) continue;
                hashSet.add(zzZQU2.getId());
            }
            return hashSet;
        }
        return null;
    }

    public final Set getCriticalExtensionOIDs() {
        return this.zzNn(true);
    }

    public final Set getNonCriticalExtensionOIDs() {
        return this.zzNn(false);
    }

    @Override
    public final byte[] getExtensionValue(String oid) {
        zzZLG zzZLG2;
        zzZLF zzZLF2 = this.zzWyR.zzY2P().zzY3p();
        if (zzZLF2 != null && (zzZLG2 = zzZLF2.zzS(new zzZQU(oid))) != null) {
            try {
                return zzZLG2.zzY2E().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    @Override
    public final byte[] getEncoded() throws CRLException {
        try {
            return this.zzWyR.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public final void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = Signature.getInstance(this.getSigAlgName(), this.zzWCx);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.zzZ(key, signature);
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = sigProvider != null ? Signature.getInstance(this.getSigAlgName(), sigProvider) : Signature.getInstance(this.getSigAlgName());
        this.zzZ(key, signature);
    }

    private void zzZ(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.zzWyR.zzY2R().equals(this.zzWyR.zzY2P().zzY2l())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        if (this.zzWyP != null) {
            try {
                zzZ1Q.zzZ(signature, zzZQP.zzXM(this.zzWyP));
            }
            catch (IOException iOException) {
                throw new SignatureException("cannot decode signature parameters: " + iOException.getMessage());
            }
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    @Override
    public final int getVersion() {
        return this.zzWyR.zzY2X();
    }

    @Override
    public final Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public final X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.zzWyR.zzY2W().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public final Date getThisUpdate() {
        return this.zzWyR.zzY2N().zzY5I();
    }

    @Override
    public final Date getNextUpdate() {
        if (this.zzWyR.zzY2M() != null) {
            return this.zzWyR.zzY2M().zzY5I();
        }
        return null;
    }

    private Set zzXUC() {
        HashSet<zzZ1U> hashSet = new HashSet<zzZ1U>();
        Enumeration enumeration = this.zzWyR.zzY2O();
        zzZLX zzZLX2 = null;
        while (enumeration.hasMoreElements()) {
            zzZLG zzZLG2;
            zzZKY.zzZ zzZ100 = (zzZKY.zzZ)enumeration.nextElement();
            zzZ1U zzZ1U2 = new zzZ1U(zzZ100, this.zzWyO, zzZLX2);
            hashSet.add(zzZ1U2);
            if (!this.zzWyO || !zzZ100.hasExtensions() || (zzZLG2 = zzZ100.zzY3p().zzS(zzZLG.zzX6B)) == null) continue;
            zzZLX2 = zzZLX.zzXB(zzZLC.zzXm(zzZLG2.zzY2D()).zzY2A()[0].zzY2G());
        }
        return hashSet;
    }

    @Override
    public final X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        Enumeration enumeration = this.zzWyR.zzY2O();
        zzZLX zzZLX2 = null;
        while (enumeration.hasMoreElements()) {
            zzZLG zzZLG2;
            zzZKY.zzZ zzZ100 = (zzZKY.zzZ)enumeration.nextElement();
            if (serialNumber.equals(zzZ100.zzY2k().zzY5P())) {
                return new zzZ1U(zzZ100, this.zzWyO, zzZLX2);
            }
            if (!this.zzWyO || !zzZ100.hasExtensions() || (zzZLG2 = zzZ100.zzY3p().zzS(zzZLG.zzX6B)) == null) continue;
            zzZLX2 = zzZLX.zzXB(zzZLC.zzXm(zzZLG2.zzY2D()).zzY2A()[0].zzY2G());
        }
        return null;
    }

    public final Set getRevokedCertificates() {
        Set set = this.zzXUC();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    @Override
    public final byte[] getTBSCertList() throws CRLException {
        try {
            return this.zzWyR.zzY2P().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public final byte[] getSignature() {
        return this.zzWyR.zzY2Q().zzY5V();
    }

    @Override
    public final String getSigAlgName() {
        return this.zzWyQ;
    }

    @Override
    public final String getSigAlgOID() {
        return this.zzWyR.zzY2R().zzY41().getId();
    }

    @Override
    public final byte[] getSigAlgParams() {
        if (this.zzWyP != null) {
            byte[] byArray = new byte[this.zzWyP.length];
            System.arraycopy(this.zzWyP, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    @Override
    public final String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = zzYVV.zzXSC();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(zzYVV.zzWd(zzYVP.zzb(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(zzYVV.zzWd(zzYVP.zzb(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(zzYVV.zzWd(zzYVP.zzb(byArray, i, byArray.length - i))).append(string);
        }
        zzZLF zzZLF2 = this.zzWyR.zzY2P().zzY3p();
        if (zzZLF2 != null) {
            object2 = zzZLF2.zzY2C();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (zzZQU)object2.nextElement();
                zzZLG zzZLG2 = zzZLF2.zzS((zzZQU)object);
                if (zzZLG2.zzY2E() != null) {
                    byte[] byArray2 = zzZLG2.zzY2E().zzY5V();
                    stringBuffer.append("                       critical(").append(zzZLG2.isCritical()).append(") ");
                    try {
                        zzZQP zzZQP2 = zzZQP.zzXM(byArray2);
                        if (((zzZQP)object).equals(zzZLG.zzX6F)) {
                            stringBuffer.append(new zzZLO(zzZQX.zzYO(zzZQP2).zzY5B())).append(string);
                            continue;
                        }
                        if (((zzZQP)object).equals(zzZLG.zzX6D)) {
                            stringBuffer.append("Base CRL: " + new zzZLO(zzZQX.zzYO(zzZQP2).zzY5B())).append(string);
                            continue;
                        }
                        if (((zzZQP)object).equals(zzZLG.zzX6C)) {
                            stringBuffer.append(zzZL9.zzXj(zzZQP2)).append(string);
                            continue;
                        }
                        if (((zzZQP)object).equals(zzZLG.zzX6z)) {
                            stringBuffer.append(zzZLP.zzXx(zzZQP2)).append(string);
                            continue;
                        }
                        if (((zzZQP)object).equals(zzZLG.zzX6t)) {
                            stringBuffer.append(zzZLP.zzXx(zzZQP2)).append(string);
                            continue;
                        }
                        stringBuffer.append(((zzZQU)object).getId());
                        stringBuffer.append(" value = ").append(zzZM0.zzXE(zzZQP2)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((zzZQU)object).getId());
                        stringBuffer.append(" value = *****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final boolean isRevoked(Certificate cert) {
        if (!cert.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.zzWyR.zzY2O();
        zzZLX zzZLX2 = this.zzWyR.zzY2W();
        if (enumeration.hasMoreElements()) {
            BigInteger bigInteger = ((X509Certificate)cert).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                zzZQV zzZQV2;
                zzZKY.zzZ zzZ100 = zzZKY.zzZ.zzXb(enumeration.nextElement());
                if (this.zzWyO && zzZ100.hasExtensions() && (zzZQV2 = zzZ100.zzY3p().zzS(zzZLG.zzX6B)) != null) {
                    zzZLX2 = zzZLX.zzXB(zzZLC.zzXm(zzZQV2.zzY2D()).zzY2A()[0].zzY2G());
                }
                if (!zzZ100.zzY2k().zzY5P().equals(bigInteger)) continue;
                if (cert instanceof X509Certificate) {
                    zzZQV2 = zzZLX.zzXB(((X509Certificate)cert).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        zzZQV2 = zzZKX.zzXa(cert.getEncoded()).zzY2W();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
                    }
                }
                return zzZLX2.equals(zzZQV2);
            }
        }
        return false;
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof X509CRL)) {
            return false;
        }
        if (other instanceof zzZ1T) {
            boolean bl;
            zzZ1T zzZ1T2 = (zzZ1T)other;
            if (this.zzX6Q && (bl = zzZ1T2.zzX6Q) && zzZ1T2.zzX8r != this.zzX8r) {
                return false;
            }
            return this.zzWyR.equals(zzZ1T2.zzWyR);
        }
        return super.equals(other);
    }

    @Override
    public final int hashCode() {
        if (!this.zzX6Q) {
            this.zzX8r = super.hashCode();
            this.zzX6Q = true;
        }
        return this.zzX8r;
    }
}

