/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zz24;
import com.aspose.words.internal.zz3G;
import com.aspose.words.internal.zz7Z;
import com.aspose.words.internal.zzSO;
import com.aspose.words.internal.zzYS;
import com.aspose.words.internal.zzZYM;
import com.aspose.words.internal.zzZYO;
import com.aspose.words.zzZGU;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzZda;
    private zzZGU zzXwj;

    Watermark(Document doc, zzZGU watermarkProvider) {
        this.zzZda = doc;
        this.zzXwj = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzBb(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzZ(text, textWatermarkOptions, this.zzZda);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzYS.zzY((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzZda, 75);
        shape.getImageData().setImage(image);
        this.zzZ(shape, options, this.zzZda);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzYS.zzY((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzZda, 75);
        shape.getImageData().setImage(imagePath);
        this.zzZ(shape, options, this.zzZda);
    }

    public final int getType() {
        Shape shape = this.zzXwj.get();
        if (shape == null) {
            return 2;
        }
        shape.zzYru();
        if (shape.zzYrt()) {
            return 0;
        }
        if (shape.zzYrs()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzXwj.add(shape);
    }

    public final void remove() {
        this.zzXwj.remove();
    }

    private static void zzBb(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zz7Z.zzXC(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzYS.zzZ(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzZ(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzY(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzV(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzY(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzZ8j() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzZ4U()) / d2) > (double)(f = pageSetup.zzZ4T())) {
            d = (double)f / d3;
        }
        shape.zzWV(zzZYO.zzZ(d2 * d, 2, zz24.zz8O));
        shape.zzWU(zzZYO.zzZ(d3 * d, 2, zz24.zz8O));
    }

    private Shape zzZ(String string, TextWatermarkOptions textWatermarkOptions, Document document) throws Exception {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzZ(shape, textWatermarkOptions, document);
        shape.getFill().setColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzV(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzZ(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzYg8() ? 1.0f : textWatermarkOptions.getFontSize();
        zzSO zzSO2 = document.zzZzm().zzX(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzSO2.zzb(shape.getTextPath().getText());
        if (textWatermarkOptions.zzYg8()) {
            l = Watermark.zzZ(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzWV(zzZYO.zzZ(Float.intBitsToFloat(n), 2, zz24.zz8O));
        shape.zzWU(zzZYO.zzZ(zz3G.zzYE(l), 2, zz24.zz8O));
    }

    private static long zzZ(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzZ4U();
        float f2 = pageSetup.zzZ4T();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zz3G.zzYE(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zz3G.zzF(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zz3G.zzYE(l) >= Float.intBitsToFloat(n)) {
            return zz3G.zzF(f2 / f3, f2);
        }
        float f6 = f;
        return zz3G.zzF(f6, f6 * f3);
    }

    private static void zzV(Shape shape, String string) {
        shape.setName(zzZYM.zzY("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

