/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzYS;
import com.aspose.words.zzYPY;
import com.aspose.words.zzZHD;
import com.aspose.words.zzZI3;

public final class Section
extends CompositeNode<Node>
implements zzZHD {
    private zzYPY zzYeW;
    private PageSetup zzXPF;
    private HeaderFooterCollection zzXPE;

    public Section(DocumentBase doc) {
        this(doc, new zzYPY());
    }

    Section(DocumentBase doc, zzYPY sectPr) {
        super(doc);
        this.zzYeW = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzXPE == null) {
            this.zzXPE = new HeaderFooterCollection(this);
        }
        return this.zzXPE;
    }

    public final PageSetup getPageSetup() {
        if (this.zzXPF == null) {
            Section section = this;
            this.zzXPF = new PageSetup(section, section.getDocument().zzZyP(), this.getDocument().getStyles(), new zzZ(this));
        }
        return this.zzXPF;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzYFU();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzQT(!value);
    }

    final zzYPY zzYLD() {
        return this.zzYeW;
    }

    final void zzY(zzYPY zzYPY2) {
        this.zzYeW = zzYPY2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzZ(boolean bl, zzZI3 zzZI32) {
        zzYPY zzYPY2;
        Section section = (Section)super.zzZ(bl, zzZI32);
        zzYPY zzYPY3 = this.zzYeW;
        section.zzYeW = zzYPY2 = (zzYPY)zzYPY3.zzhP();
        section.zzXPF = null;
        section.zzXPE = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) throws Exception {
        this.zzW(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) throws Exception {
        this.zzW(sourceSection, true);
    }

    public final void clearContent() throws Exception {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() throws Exception {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzpk(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzS(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzpk(n) == null;
            }
        }
        return false;
    }

    final void zzX(Shape shape, boolean bl) throws Exception {
        this.zzZ(shape, 4, bl);
        this.zzZ(shape, 0, bl);
        this.zzZ(shape, 1, bl);
    }

    private void zzZ(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        headerFooter.getFirstParagraph().appendChild(shape.deepClone(true));
    }

    final void zzYtX() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzYnj()) {
                if (!shape.zzYru()) continue;
                shape.remove();
            }
        }
    }

    private void zzW(Section section, boolean bl) throws Exception {
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        Paragraph paragraph = bl ? body2.getLastParagraph() : null;
        body2.zzY(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzYeW.zzQ5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzZyP().zzZeA.zzQ4(key);
        }
        return zzYPY.zzPv(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzYeW.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzZyP().zzZeA.zzN(key, value);
            return;
        }
        this.zzYeW.zzN(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzYeW.clear();
    }

    final boolean zzZ7X() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzZ7Y() {
        return this.getParentNode().getLastChild() == this;
    }

    static final class zzZ
    implements zzZHD {
        private Section zzYeG;

        zzZ(Section section) {
            this.zzYeG = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzYtW().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzYtW().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzYtW().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZHD zzYtW() {
            Document document = zzYS.zzZ((Object)this.zzYeG.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzYeG;
        }
    }
}

