/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zz2C;
import com.aspose.words.internal.zzPT;

public abstract class SaveOptions {
    private boolean zzXQp;
    private boolean zzXQo = true;
    private boolean zzXQn = false;
    private boolean zzXQm = true;
    private boolean zzD6;
    private String zzhd;
    private boolean zzXQl;
    private boolean zzXQk = false;
    private boolean zzXQj = true;
    private int zzXQi = 1;
    private int zzZke = 0;
    private String zzXQh = "";
    private boolean zzXQg = true;
    private boolean zzXQf = true;
    private boolean zzXQe;
    private boolean zzXQd;
    private int zzYCR = 0;
    private boolean zzXQc = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZbE() {
        return false;
    }

    boolean zzZjw() {
        return true;
    }

    final boolean zzYuH() {
        return this.zzXQm;
    }

    public String getTempFolder() {
        return this.zzhd;
    }

    public void setTempFolder(String value) {
        this.zzhd = value;
    }

    public boolean getPrettyFormat() {
        return this.zzD6;
    }

    public void setPrettyFormat(boolean value) {
        this.zzD6 = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzXQl;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzXQl = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzXQk;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzXQk = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzXQj;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzXQj = value;
    }

    public int getDmlRenderingMode() {
        return this.zzXQi;
    }

    public void setDmlRenderingMode(int value) {
        this.zzXQi = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzZke;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzZke = value;
    }

    public String getDefaultTemplate() {
        return this.zzXQh;
    }

    public void setDefaultTemplate(String value) {
        this.zzXQh = value;
    }

    public boolean getUpdateFields() {
        return this.zzXQg;
    }

    public void setUpdateFields(boolean value) {
        this.zzXQg = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzXQe;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzXQe = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzXQd;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzXQd = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXQn;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXQn = value;
    }

    final boolean zzYuG() {
        return this.zzXQf;
    }

    final boolean zzYuF() {
        return this.zzXQc;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzD7(zzPT.zzZY(zz2C.zzVZ(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzYCR;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzYCR = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzXQp;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzXQp = value;
    }

    final boolean zzYuE() {
        return this.zzXQo;
    }
}

