/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Cell;
import com.aspose.words.Comment;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Field;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FrameFormat;
import com.aspose.words.HeaderFooter;
import com.aspose.words.Inline;
import com.aspose.words.List;
import com.aspose.words.ListFormat;
import com.aspose.words.ListLabel;
import com.aspose.words.ListLevel;
import com.aspose.words.Node;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.Run;
import com.aspose.words.RunCollection;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.TabStop;
import com.aspose.words.Table;
import com.aspose.words.TableStyle;
import com.aspose.words.WordAttrCollection;
import com.aspose.words.internal.zzYS;
import com.aspose.words.internal.zzZYM;
import com.aspose.words.ref.RefBoolean;
import com.aspose.words.ref.RefDouble;
import com.aspose.words.zz0W;
import com.aspose.words.zz6;
import com.aspose.words.zzCS;
import com.aspose.words.zzYIA;
import com.aspose.words.zzYR4;
import com.aspose.words.zzYYA;
import com.aspose.words.zzZ7L;
import com.aspose.words.zzZGZ;
import com.aspose.words.zzZHF;
import com.aspose.words.zzZHO;
import com.aspose.words.zzZI3;
import com.aspose.words.zzZII;
import com.aspose.words.zzZT7;
import com.aspose.words.zzZTC;

public class Paragraph
extends CompositeNode<Node>
implements zzZGZ,
zzZHF,
zzZHO {
    private zzYYA zzZKw;
    private zzYR4 zzY7n;
    private ParagraphFormat zzY7m;
    private FrameFormat zzY7l;
    private ListFormat zzYzS;
    private ListLabel zzY7k;
    private RunCollection zzY7j;
    private int zzY7i;
    private int zzY7h;

    public Paragraph(DocumentBase doc) {
        this(doc, new zzYYA(), new zzYR4());
    }

    Paragraph(DocumentBase doc, zzYYA paraPr, zzYR4 runPr) {
        super(doc);
        this.zzZKw = paraPr;
        this.zzY7n = runPr;
    }

    @Override
    public int getNodeType() {
        return 8;
    }

    public Story getParentStory() {
        return (Story)this.getAncestor(Story.class);
    }

    public Section getParentSection() {
        return (Section)this.getAncestor(2);
    }

    public boolean isInCell() {
        return this.zzYQW() instanceof Cell;
    }

    final boolean zzYFh() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode == null) {
            return false;
        }
        if (zzCS.zzf(compositeNode)) {
            if (this.isInCell()) {
                Paragraph paragraph = this;
                if (paragraph.zzYm(paragraph.zzYQW().getFirstChild())) {
                    return true;
                }
            }
            return false;
        }
        return this.isInCell() && this == compositeNode.zz6T();
    }

    public boolean isEndOfCell() {
        CompositeNode compositeNode = this.zzYQW();
        return compositeNode instanceof Cell && compositeNode.zz6S() == this;
    }

    public boolean getBreakIsStyleSeparator() {
        return zzCS.zzW(this.zzY7n, 130) && zzCS.zzW(this.zzY7n, 10);
    }

    final boolean zzYFg() {
        return this.isEndOfCell() && this.zzZos().isLastCell();
    }

    final Cell zzZos() {
        return zzYS.zzZ((Object)this.zzYQW(), Cell.class);
    }

    final Row getParentRow() {
        if (this.zzZos() != null) {
            return this.zzZos().getParentRow();
        }
        return null;
    }

    final Table getParentTable() {
        if (this.getParentRow() != null) {
            return this.getParentRow().getParentTable();
        }
        return null;
    }

    public boolean isEndOfSection() {
        Story story = this.getParentStory();
        return story != null && story.getStoryType() == 1 && this == story.zz6S();
    }

    public boolean isEndOfHeaderFooter() {
        Story story = this.getParentStory();
        return story instanceof HeaderFooter && story.zz6S() == this;
    }

    public boolean isEndOfDocument() {
        if (!this.isEndOfSection()) {
            return false;
        }
        for (Node node = this.getDocument().getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (!(node instanceof Section)) continue;
            return node == this.getParentSection();
        }
        return true;
    }

    final boolean zzYFf() {
        if (this.zzYQN() != null) {
            return false;
        }
        if (this.getParentNode().getNodeType() != 3) {
            return false;
        }
        return !this.getParentSection().zzYQM();
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzY7m == null) {
            Paragraph paragraph = this;
            this.zzY7m = new ParagraphFormat(paragraph, paragraph.getDocument().getStyles());
        }
        return this.zzY7m;
    }

    public ListFormat getListFormat() {
        if (this.zzYzS == null) {
            Paragraph paragraph = this;
            this.zzYzS = new ListFormat(paragraph, paragraph, this.getDocument().getLists());
        }
        return this.zzYzS;
    }

    public FrameFormat getFrameFormat() {
        if (this.zzY7l == null) {
            this.zzY7l = new FrameFormat(this);
        }
        return this.zzY7l;
    }

    public ListLabel getListLabel() {
        if (this.zzY7k == null) {
            this.zzY7k = new ListLabel(this);
        }
        return this.zzY7k;
    }

    public RunCollection getRuns() {
        if (this.zzY7j == null) {
            this.zzY7j = new RunCollection(this);
        }
        return this.zzY7j;
    }

    public Font getParagraphBreakFont() {
        Paragraph paragraph = this;
        return new Font(paragraph, paragraph.getDocument());
    }

    public boolean isInsertRevision() {
        return this.zzY7n.zzYHQ();
    }

    public boolean isDeleteRevision() {
        return this.zzY7n.zzYHR();
    }

    public boolean isMoveFromRevision() {
        return this.zzY7n.zzYcn();
    }

    public boolean isMoveToRevision() {
        return this.zzY7n.zzYcm();
    }

    public boolean isFormatRevision() {
        return this.zzZKw.zzek();
    }

    final Style zzYFe() {
        return this.zzsX(0);
    }

    final Style zzsX(int n) {
        Object object = this.zzZKw.zzWp(1000, n);
        int n2 = object != null ? (Integer)object : 0;
        return this.getDocument().getStyles().zzW0(n2, 0);
    }

    private Style zzYFd() {
        return this.getDocument().getStyles().zzW0(this.zzY7n.zzZhJ(), 10);
    }

    final zzYYA zz6J() {
        return this.zzZKw;
    }

    final void zzZ(zzYYA zzYYA2) {
        this.zzZKw = zzYYA2;
    }

    final void zzYM(Paragraph paragraph) {
        if (paragraph.getListLabel().zzZ1Y() != null && paragraph.getListLabel().zzZ21() != null) {
            this.getListLabel().zzZ(paragraph.getListLabel().zzZ1Y(), paragraph.getListLabel().zzZdd(), paragraph.getListLabel().zzZ21().zzZ1t(), 0);
        }
        if (paragraph.getListLabel().zzZ1W() != null && paragraph.getListLabel().zzZ20() != null) {
            this.getListLabel().zzZ(paragraph.getListLabel().zzZ1W(), paragraph.getListLabel().zzZ1U(), paragraph.getListLabel().zzZ20().zzZ1t(), 1);
        }
    }

    final void zzsW(int n) {
        if (this.zzY7k != null) {
            this.zzY7k.zzZ(null, null, null, n);
        }
    }

    final zzYR4 zzYFc() {
        return this.zzY7n;
    }

    final void zzH(zzYR4 zzYR42) {
        this.zzY7n = zzYR42;
    }

    @Override
    final Node zzZ(boolean bl, zzZI3 zzZI32) {
        zzYR4 zzYR42;
        zzYYA zzYYA2;
        Paragraph paragraph = (Paragraph)super.zzZ(bl, zzZI32);
        WordAttrCollection wordAttrCollection = this.zzZKw;
        paragraph.zzZKw = zzYYA2 = (zzYYA)wordAttrCollection.zzhP();
        wordAttrCollection = this.zzY7n;
        paragraph.zzY7n = zzYR42 = (zzYR4)wordAttrCollection.zzhP();
        paragraph.zzY7m = null;
        paragraph.zzY7l = null;
        paragraph.zzYzS = null;
        paragraph.zzY7k = null;
        paragraph.zzY7j = null;
        return paragraph;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitParagraphStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitParagraphEnd(this);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    final zzYYA zzsV(int n) {
        zzYYA zzYYA2 = new zzYYA();
        this.zzY(zzYYA2, n);
        return zzYYA2;
    }

    final void zzY(zzYYA zzYYA2, int n) {
        TableStyle tableStyle;
        Cloneable cloneable;
        Cloneable cloneable2;
        Cloneable cloneable3;
        boolean bl = (n & 0x40) != 0;
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 0x80) == 0;
        n &= 0xFFFFFF7F;
        if (bl2) {
            this.getDocument().getStyles().zzYlS().zzZ((zz6)zzYYA2, bl);
        }
        if ((n & 4) != 0 && (cloneable3 = this.zzZos()) != null && (cloneable2 = ((Cell)(cloneable = cloneable3)).getParentRow().getParentTable()) != null && (tableStyle = zzYS.zzZ((Object)((Table)cloneable2).getStyle(), TableStyle.class)) != null) {
            tableStyle.zzZ((Cell)cloneable3, zzYYA2);
        }
        cloneable3 = this.zzZKw.zzt2(n);
        if ((n & 0x10) != 0 && this.zzZKw.zzek()) {
            zzYYA2.zzZ((zzZT7)this.zzZKw.zzYIN().deepCloneComplexAttr());
        }
        cloneable2 = this.getDocument().getStyles().zzW0(((zzYYA)cloneable3).zzZhJ(), 0);
        int n2 = bl2 ? n & 0xFFFFFFFE : n;
        n2 = bl ? n2 & 0xFFFFFFBF : n2;
        ((Style)cloneable2).zzY(zzYYA2, n2);
        if (zzYYA2.getListId() != ((zzYYA)cloneable3).getListId() || zzYYA2.zzZ5c() != ((zzYYA)cloneable3).zzZ5c()) {
            Cloneable cloneable4 = cloneable3;
            if (!((zz6)cloneable3).zzV7(1110) && zzYYA2.zzV7(1110)) {
                cloneable = cloneable3;
                cloneable4 = (zzYYA)((zz6)cloneable).zzhP();
                ((zz6)cloneable4).zzN(1110, zzYYA2.get(1110));
            }
            this.getDocument().getLists().zzZ((zzYYA)cloneable4, zzYYA2);
        }
        if ((n & 8) != 0 && this.zzZKw.zzV7(1585)) {
            this.getDocument().zzZyW().zzZ(this.zzZKw, zzYYA2, this.getParentTable() == null);
        }
        if (bl3) {
            ((zz6)cloneable3).zzY(zzYYA2);
        }
        ((zzYYA)cloneable3).zzM(zzYYA2);
        if (((zzYYA)cloneable3).zzYFP()) {
            if (!((zz6)cloneable3).zzV7(1170)) {
                zzYYA2.zzy0(0);
            }
            if (!((zz6)cloneable3).zzV7(1160)) {
                zzYYA2.zzxZ(0);
            }
            if (!((zz6)cloneable3).zzV7(1165)) {
                if (bl) {
                    zzYYA2.set(1165, 0);
                } else {
                    zzYYA2.remove(1165);
                }
            }
            if (!((zz6)cloneable3).zzV7(1175)) {
                if (bl) {
                    zzYYA2.set(1175, 0);
                } else {
                    zzYYA2.remove(1175);
                }
            }
        }
        if (((Node)(cloneable = this)).zzYQW() instanceof Shape) {
            zzYYA2.zzYFq();
        }
        if ((n & 2) != 0) {
            zzYYA2.zzYFp();
        }
    }

    final zzYR4 zzsU(int n) {
        zzYR4 zzYR42 = new zzYR4();
        int n2 = n;
        zzYR4 zzYR43 = zzYR42;
        Paragraph paragraph = this;
        zzCS.zzZ(paragraph, zzYR43, n2);
        return zzYR42;
    }

    final void zzL(zzYYA zzYYA2) {
        for (int i = 0; i < zzYYA2.getCount(); ++i) {
            Object object;
            int n = zzYYA2.zzSK(i);
            Object object2 = zzYYA2.zzVe(i);
            if (object2.equals(object = this.fetchInheritedParaAttr(n))) {
                this.zzZKw.remove(n);
                continue;
            }
            this.zzZKw.zzN(n, object2);
        }
    }

    final boolean zzYFb() {
        CompositeNode compositeNode = this.zzYQW();
        return compositeNode instanceof Comment && this == compositeNode.zz6S();
    }

    final boolean zzYFa() {
        CompositeNode compositeNode = this.zzYQW();
        return compositeNode instanceof Footnote && this == compositeNode.zz6S();
    }

    final boolean zzYF9() {
        CompositeNode compositeNode = this.zzYQW();
        return compositeNode instanceof zzZTC && this == compositeNode.zz6S();
    }

    final boolean zzYF8() {
        CompositeNode compositeNode = this.zzYQW();
        return compositeNode instanceof Shape && compositeNode.zz6S() == this;
    }

    final void zzZ(RefDouble refDouble, RefDouble refDouble2, RefBoolean refBoolean) {
        refDouble.set(2.147483647E9);
        refDouble2.set(0.0);
        refBoolean.set(false);
        for (Node node = this.zz6V(); node != null; node = node.zzYQQ()) {
            if (!(node instanceof Inline)) continue;
            Paragraph.zzZ((Inline)node, refDouble, refDouble2, refBoolean);
        }
        if (refDouble2.get() == 0.0) {
            Paragraph.zzZ(this, refDouble, refDouble2, refBoolean);
        }
    }

    private static void zzZ(zzZHF zzZHF2, RefDouble refDouble, RefDouble refDouble2, RefBoolean refBoolean) {
        Object object = zzZHF2.getDirectRunAttr(190);
        int n = (Integer)(object != null ? object : zzZHF2.fetchInheritedRunAttr(190));
        double d = (double)n / 2.0;
        refDouble.set(Math.min(d, refDouble.get()));
        refDouble2.set(Math.max(d, refDouble2.get()));
        if (!refBoolean.get()) {
            refBoolean.set(object != null);
            if (!refBoolean.get()) {
                Object object2 = zzZHF2.getDirectRunAttr(50);
                refBoolean.set(object2 != null && (Integer)object2 != 10);
            }
        }
    }

    @Override
    final String zz6P() {
        if (this.isEndOfCell()) {
            return ControlChar.CELL;
        }
        if (this.isEndOfSection()) {
            return ControlChar.SECTION_BREAK;
        }
        return ControlChar.PARAGRAPH_BREAK;
    }

    @Override
    final boolean zzS(Node node) {
        return zzCS.zzh(node);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzZKw.zzQ5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        return this.zzX0(key, 0);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        return this.zzWZ(key, 0);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        this.zzZKw.zzN(key, value);
        switch (key) {
            case 1155: 
            case 1165: 
            case 1175: 
            case 1205: 
            case 1225: {
                this.zzYEY();
            }
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzZKw.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzZKw.clear();
    }

    private Object zzX0(int n, int n2) {
        Object object;
        Object object2;
        Paragraph paragraph = this;
        ListLevel listLevel = this.getDocument().getLists().zzZ(paragraph.zzZKw, n2);
        if (listLevel != null) {
            object2 = listLevel.zz6J().zzQ5(n);
            if (object2 != null) {
                return object2;
            }
        } else {
            object = this.zzZKw.zzWp(1120, n2);
            if (object != null && (Integer)object == 0 && zzYYA.zzt1(n)) {
                return 0;
            }
        }
        if ((object2 = this.zzsX(n2).zzW6(n, n2)) != null) {
            return object2;
        }
        if (this.zzYF7() && (object2 = ((TableStyle)(object = (TableStyle)this.getParentTable().getStyle())).zzX(n, this.zzZos())) != null) {
            return object2;
        }
        return this.getDocument().getStyles().zzYlS().zzQ4(n);
    }

    private boolean zzYF7() {
        Cell cell = this.zzZos();
        if (cell == null) {
            return false;
        }
        Row row = cell.getParentRow();
        if (row == null) {
            return false;
        }
        Table table = row.getParentTable();
        if (table == null) {
            return false;
        }
        TableStyle tableStyle = zzYS.zzZ((Object)this.getDocument().getStyles().zzZd(this.getParentTable().zzZhJ(), false), TableStyle.class);
        if (tableStyle == null) {
            return false;
        }
        return tableStyle.getStyleIdentifier() != 105;
    }

    final Object zzWZ(int n, int n2) {
        Object object = this.zzZKw.zzWp(n, n2);
        if (object != null) {
            return object;
        }
        return this.zzX0(n, n2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key) {
        return this.zzY7n.zzQ5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int key) {
        Object object = this.zzYFd().zzZf(key, false);
        if (object != null) {
            return object;
        }
        Paragraph paragraph = this;
        return paragraph.zzsX(0).zzZf(key, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int key, Object value) {
        this.zzY7n.zzN(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzY7n.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzY7n.clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz0W getInsertRevision() {
        Paragraph paragraph = this;
        return paragraph.zzY7n.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zz0W value) {
        Cloneable cloneable = this;
        zz0W zz0W2 = value;
        cloneable = cloneable.zzY7n;
        ((zz6)cloneable).zzN(14, zz0W2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz0W getDeleteRevision() {
        Paragraph paragraph = this;
        return paragraph.zzY7n.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zz0W value) {
        Cloneable cloneable = this;
        zz0W zz0W2 = value;
        cloneable = cloneable.zzY7n;
        ((zz6)cloneable).zzN(12, zz0W2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ7L getMoveFromRevision() {
        Paragraph paragraph = this;
        return paragraph.zzY7n.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzZ7L value) {
        Cloneable cloneable = this;
        zzZ7L zzZ7L2 = value;
        cloneable = cloneable.zzY7n;
        ((zz6)cloneable).zzN(13, zzZ7L2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ7L getMoveToRevision() {
        Paragraph paragraph = this;
        return paragraph.zzY7n.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzZ7L value) {
        Cloneable cloneable = this;
        zzZ7L zzZ7L2 = value;
        cloneable = cloneable.zzY7n;
        ((zz6)cloneable).zzN(15, zzZ7L2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Paragraph paragraph = this;
        paragraph.zzY7n.remove(13);
        paragraph = this;
        paragraph.zzY7n.remove(15);
    }

    final boolean zzYF6() throws Exception {
        double d;
        CompositeNode compositeNode = this.zzYQO();
        if (!(compositeNode instanceof Paragraph)) {
            return false;
        }
        Paragraph paragraph = (Paragraph)compositeNode;
        ParagraphFormat paragraphFormat = this.getParagraphFormat();
        ParagraphFormat paragraphFormat2 = paragraph.getParagraphFormat();
        if (paragraphFormat2.getPageBreakBefore()) {
            return false;
        }
        Paragraph paragraph2 = paragraph;
        Paragraph paragraph3 = paragraph2;
        paragraph3 = this;
        if (paragraph2.zzZKw.zzYFy() != paragraph3.zzZKw.zzYFy()) {
            return false;
        }
        double d2 = paragraphFormat.getLeftIndent() + Math.min(paragraphFormat.getFirstLineIndent(), 0.0);
        if (d2 != (d = paragraphFormat2.getLeftIndent() + Math.min(paragraphFormat2.getFirstLineIndent(), 0.0))) {
            return false;
        }
        if (paragraphFormat.getRightIndent() != paragraphFormat2.getRightIndent()) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(1).equals(paragraphFormat2.getBorders().getByBorderType(1))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(2).equals(paragraphFormat2.getBorders().getByBorderType(2))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(3).equals(paragraphFormat2.getBorders().getByBorderType(3))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(0).equals(paragraphFormat2.getBorders().getByBorderType(0))) {
            return false;
        }
        return this.zzYL(paragraph);
    }

    private boolean zzYL(Paragraph paragraph) {
        Paragraph paragraph2 = paragraph;
        return this.zzZKw.zzN(paragraph2.zzZKw);
    }

    final Run zzZ7W() {
        return (Run)this.getChild(21, 0, false);
    }

    final Run zzQS(boolean bl) {
        Run run = null;
        for (Node node = this.zz6V(); node != null; node = node.zzYQQ()) {
            if (node.getNodeType() != 21 || bl && zzZYM.zzUT(node.getText())) continue;
            run = (Run)node;
        }
        return run;
    }

    final boolean zzZi1() {
        Story story = this.getParentStory();
        return story != null && story.getStoryType() == 1;
    }

    public boolean isListItem() {
        return this.zzYF2();
    }

    public TabStop[] getEffectiveTabStops() {
        zzYYA zzYYA2 = this.zzsV(0);
        int n = zzYYA2.zzV7(1140) ? zzYYA2.getTabStops().getCount() : 0;
        TabStop[] tabStopArray = new TabStop[n];
        for (int i = 0; i < n; ++i) {
            tabStopArray[i] = zzYYA2.getTabStops().get(i).zzYjH();
        }
        return tabStopArray;
    }

    public int joinRunsWithSameFormatting() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        Paragraph paragraph = this;
        return Paragraph.zzZ(paragraph, stringBuilder);
    }

    final boolean zzZde() {
        return this.zzYF2() && this.getListLabel().zzSK();
    }

    final boolean zzYF5() {
        return this.zzYF1() && this.getListLabel().zzZ1Z();
    }

    final boolean hasRevisions() {
        block3: {
            block2: {
                Paragraph paragraph = this;
                if (paragraph.zzY7n.hasRevisions()) break block2;
                paragraph = this;
                if (paragraph.zzZKw.hasRevisions()) break block2;
                paragraph = this;
                if (!paragraph.zzZKw.zzYFN()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzYF4() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!zzCS.zzo(node)) continue;
            return true;
        }
        return false;
    }

    final boolean zzYF3() {
        for (Node node : this.getChildNodes()) {
            if (zzCS.zzm(node)) continue;
            return false;
        }
        return true;
    }

    final int zzy(StringBuilder stringBuilder) throws Exception {
        return Paragraph.zzZ(this, stringBuilder);
    }

    private static int zzZ(CompositeNode compositeNode, StringBuilder stringBuilder) throws Exception {
        if (stringBuilder != null) {
            stringBuilder.length();
        }
        int n = 0;
        Run run = null;
        zzYR4 zzYR42 = null;
        for (Node node = compositeNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node node2;
            if (node.getNodeType() == 21) {
                node2 = (Run)node;
                if (run != null) {
                    int n2 = 33;
                    Run run2 = node2;
                    zzYR4 zzYR43 = zzCS.zzZ((zzZII)run2, n2);
                    if (zzYR42 == null) {
                        n2 = 33;
                        run2 = run;
                        zzYR42 = zzCS.zzZ((zzZII)run2, n2);
                    }
                    if (zzYR4.zzW(zzYR43, zzYR42)) {
                        if (stringBuilder.length() == 0) {
                            zzYS.zzY(stringBuilder, run.getText());
                        }
                        zzYS.zzY(stringBuilder, ((Run)node2).getText());
                        ++n;
                        compositeNode.removeChild(run);
                    } else {
                        Paragraph.zzZ(run, stringBuilder);
                        zzYR42 = null;
                    }
                }
                run = node2;
            } else {
                Paragraph.zzZ(run, stringBuilder);
                run = null;
                zzYR42 = null;
            }
            if (node.getNodeType() != 28) continue;
            node2 = (StructuredDocumentTag)node;
            Paragraph.zzZ((CompositeNode)node2, stringBuilder);
        }
        Paragraph.zzZ(run, stringBuilder);
        stringBuilder.length();
        return n;
    }

    private static void zzZ(Run run, StringBuilder stringBuilder) throws Exception {
        if (run != null && stringBuilder.length() != 0) {
            run.setText(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
    }

    public Field appendField(int fieldType, boolean updateField) throws Exception {
        return this.insertField(fieldType, updateField, null, true);
    }

    public Field appendField(String fieldCode) throws Exception {
        return this.insertField(fieldCode, null, true);
    }

    public Field appendField(String fieldCode, String fieldValue) throws Exception {
        return this.insertField(fieldCode, fieldValue, null, true);
    }

    public Field insertField(int fieldType, boolean updateField, Node refNode, boolean isAfter) throws Exception {
        return zzCS.zzZ(fieldType, updateField, this.zz9(refNode), null, (CompositeNode)this, refNode, isAfter);
    }

    public Field insertField(String fieldCode, Node refNode, boolean isAfter) throws Exception {
        return zzCS.zzZ(fieldCode, this.zz9(refNode), null, (CompositeNode)this, refNode, isAfter);
    }

    public Field insertField(String fieldCode, String fieldValue, Node refNode, boolean isAfter) throws Exception {
        return zzCS.zzZ(fieldCode, fieldValue, this.zz9(refNode), null, (CompositeNode)this, refNode, isAfter);
    }

    final boolean zzYF2() {
        return (Integer)this.zzWZ(1120, 0) != 0;
    }

    final boolean zzYF1() {
        return (Integer)this.zzWZ(1120, 1) != 0;
    }

    final List zzQR(boolean bl) {
        int n = bl ? 1 : 0;
        int n2 = (Integer)this.zzWZ(1120, n);
        if (n2 == 0) {
            return null;
        }
        List list = this.getDocument().getLists().zzz4(n2);
        return list;
    }

    final ListLevel zzQQ(boolean bl) {
        int n = bl ? 1 : 0;
        int n2 = (Integer)this.zzWZ(1120, n);
        if (n2 == 0) {
            return null;
        }
        List list = this.getDocument().getLists().zzz4(n2);
        int n3 = (Integer)this.zzWZ(1110, n);
        ListLevel listLevel = list.zzz5(n3);
        return listLevel;
    }

    final int zzYF0() {
        return this.zzY7i;
    }

    final void zzsT(int n) {
        this.zzY7i = n;
    }

    final int zzYEZ() {
        return this.zzY7h;
    }

    final void zzsS(int n) {
        this.zzY7h = n;
    }

    private zzYR4 zz9(Node node) {
        if (node == null) {
            if (this.getRuns().getCount() > 0) {
                return this.getRuns().get(this.getRuns().getCount() - 1).zz6H();
            }
        } else if (node instanceof Run && node.getParentNode() == this) {
            return ((Run)node).zz6H();
        }
        Paragraph paragraph = this;
        return paragraph.zzY7n;
    }

    private void zzYEY() {
        if (this.getDocument() == null || this.getParentSection() == null || this.getDocument().getNodeType() != 1) {
            return;
        }
        zzYIA zzYIA2 = new zzYIA();
        zzYIA2.visitDocumentStart((Document)this.getDocument());
        zzYIA2.visitSectionStart(this.getParentSection());
        zzYIA2.visitParagraphStart(this);
    }
}

