/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzYS;
import com.aspose.words.zzZ6K;
import com.aspose.words.zzZ71;
import com.aspose.words.zzZ77;
import com.aspose.words.zzZI2;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzZI2,
Iterable<T> {
    private Node zzZKD;
    private CompositeNode zzYm2;
    private DocumentBase zzZT6;
    private boolean zzYYD;
    private int zzYm1;
    private int zzYm0;
    private Node zzYlZ;
    private int zzv;
    private zzZ71 zzYlY;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, new zzZ6K(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzZ6K(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzZ71 matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzYm2 = container;
        this.zzZT6 = container.getDocument();
        this.zzYlY = matcher;
        this.zzYYD = isDeep;
        this.zzZHM();
    }

    public Node get(int index) {
        try {
            this.zzYQx();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzYm0 == index) {
                return this.zzYlZ;
            }
            int n = index - this.zzYm0;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzI(nodeCollection.zzYlZ, n);
            if (node != null) {
                this.zzYm0 = index;
                this.zzYlZ = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) throws Exception {
        if (this.zzYYD) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzYm2.appendChild(node);
    }

    public void insert(int index, Node node) throws Exception {
        if (this.zzYYD) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzYm2.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzYQy();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZ77(this);
    }

    final <TNode extends Node> zzZ77<TNode> zzYQz() {
        return new zzZ77(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzYQy() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzYS.zzZ(arrayList, node);
        }
        return arrayList;
    }

    private Node zzI(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzE(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzF(curNode, true);
    }

    private Node zzF(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzZKD = node;
        do {
            node2 = this.zzZKD;
            Node node3 = this.zzYYD ? this.zzZ(true, this.zzZKD) : (this.zzZKD = this.zzYlY.zz88() ? this.zzX(true, this.zzZKD) : this.zzY(true, this.zzZKD));
        } while (this.zzZKD != null && !this.zzYlY.zzJ(this.zzZKD));
        return node2;
    }

    private Node zzE(Node node, boolean bl) throws Exception {
        while ((this.zzYYD ? this.zzZ(bl, node) : (node = this.zzYlY.zz88() ? this.zzX(bl, node) : this.zzY(bl, node))) != null && !this.zzYlY.zzJ(node)) {
        }
        return node;
    }

    private Node zzZ(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzYm2);
        }
        return node.previousPreOrder(this.zzYm2);
    }

    private Node zzY(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzYm2) {
                return this.zzYm2.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzYm2) {
            return this.zzYm2.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzX(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzYm2 ? this.zzYm2.zz6V() : node.zzYQQ();
        } else {
            Node node3 = node2 = node == this.zzYm2 ? this.zzYm2.zz6U() : node.zzYQR();
        }
        if (node2 == this.zzYm2.getNextSibling() || node2 == this.zzYm2.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzYQx() {
        if (this.zzYm1 != this.zzYQw()) {
            this.zzZHM();
        }
    }

    private void zzZHM() {
        this.zzYm1 = this.zzYQw();
        this.zzYm0 = -1;
        this.zzYlZ = this.zzYm2;
        this.zzv = -1;
    }

    private int zzYQw() {
        if (this.zzZT6 != null) {
            return this.zzZT6.zzZyY();
        }
        return 0;
    }

    public int getCount() {
        this.zzYQx();
        if (this.zzv == -1) {
            this.zzv = zzZ77.zzZ(this);
        }
        return this.zzv;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZKD;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzYm2;
    }
}

