/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zz3T;
import com.aspose.words.internal.zzYS;
import com.aspose.words.internal.zzZYM;
import com.aspose.words.zz3R;
import com.aspose.words.zzCS;
import com.aspose.words.zzZI3;
import com.aspose.words.zzZJO;

public abstract class Node
implements Cloneable {
    private Node zzYmc;
    private Node zzYmb;
    private Node zzYma;
    private int zzYm9;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzY(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYmc == null) {
            return null;
        }
        if (this.zzYmc.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzYmc;
    }

    final CompositeNode zzYQW() {
        if (zzCS.zzf(this.getParentNode())) {
            return this.getParentNode().zzYQW();
        }
        return this.getParentNode();
    }

    final CompositeNode zzYQV() {
        if (zzCS.zzf(this.getParentNode()) || zzCS.zze(this.getParentNode())) {
            return this.getParentNode().zzYQV();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzYmc != null) {
            return this.zzYmc.getDocument();
        }
        return null;
    }

    final Document zzYQU() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzYQT() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzZAq();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzYma;
    }

    final Node zzYQS() {
        Node node = this;
        while ((node = node.getPreviousSibling()) != null && zzCS.zzm(node)) {
        }
        return node;
    }

    final Node zzYQR() {
        Node node = zzCS.zzS(this.getPreviousSibling(), false);
        if (node == null && zzCS.zzf(this.getParentNode())) {
            node = this.getParentNode().zzYQR();
        }
        return node;
    }

    final Node zzYQQ() {
        Node node = zzCS.zzT(this.getNextSibling(), false);
        if (node == null && zzCS.zzf(this.getParentNode())) {
            node = this.getParentNode().zzYQQ();
        }
        return node;
    }

    final CompositeNode zzYQP() {
        Node node = this;
        while ((node = node.zzYQR()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzYQO() {
        Node node = this;
        while ((node = node.zzYQQ()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzYmb;
    }

    final Node zzYQN() {
        Node node = this;
        while ((node = node.getNextSibling()) != null && zzCS.zzm(node)) {
        }
        return node;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzYQM() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzh5() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzYQL() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzCS.zzp(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzYQK() {
        return this.zzYmb;
    }

    final void zzYp(Node node) {
        this.zzYmb = node;
    }

    final Node zzYQJ() {
        return this.zzYma;
    }

    final void zzYo(Node node) {
        this.zzYma = node;
    }

    final Node zzYQI() {
        Node node = this;
        if (node.zzYmb != null) {
            node = this;
            return node.zzYmb;
        }
        return this.getParentNode();
    }

    final int zzYQH() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzCS.zzh(this);
        boolean bl2 = zzCS.zzk(this);
        boolean bl3 = zzCS.zzi(this);
        boolean bl4 = zzCS.zzj(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzYQH() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzYQH() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzZ(isCloneChildren, null);
    }

    Node zzZ(boolean bl, zzZI3 zzZI32) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYmc != null) {
            node.zzYmc = this.getDocument().zzZyX();
        }
        node.zzYmb = null;
        node.zzYma = null;
        if (zzZI32 != null) {
            zzZI32.zzW(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzK(StringBuilder stringBuilder) {
        zzYS.zzY(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzYn(Node node) {
        this.zzYmc = node != null ? node : this.getDocument().zzZyX();
    }

    final void zzY(DocumentBase documentBase) {
        this.zzYmc = documentBase != null ? documentBase.zzZyX() : null;
    }

    final boolean zzYm(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzYQG() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzvX(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzvW(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzJ(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzSe(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzZJO zzZJO2 = zzCS.zzK8(saveFormat);
        return zzZJO2.zzYG(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZJO zzZJO2 = zzCS.zzZ(saveOptions);
        return zzZJO2.zzYG(this);
    }

    final Node zzvV(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzCS.zzl(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zz3R zzYQF() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zz3R.zzZO(node);
        }
        return zz3R.zzZP(this.getParentNode());
    }

    final zz3R zzYQE() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zz3R.zzZP(node);
        }
        return zz3R.zzZO(this.getParentNode());
    }

    final boolean zzYl(Node node) {
        return Node.zzC(this, node);
    }

    final boolean zzZpR() {
        return this.getAncestor(1) == null;
    }

    static Node zzD(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zz3T<Node> zz3T2 = Node.zzYk(node);
        zz3T<Node> zz3T3 = Node.zzYk(node2);
        return Node.zzZ(zz3T2, zz3T3);
    }

    static boolean zzC(Node node, Node node2) {
        zz3T<Node> zz3T2;
        if (node == null || node2 == null) {
            return false;
        }
        zz3T<Node> zz3T3 = Node.zzYk(node);
        Node node3 = Node.zzZ(zz3T3, zz3T2 = Node.zzYk(node2));
        if (node3 == null) {
            return false;
        }
        zz3T<Node> zz3T4 = zz3T3;
        if (zz3T4.size() == 0 || (zz3T4 = zz3T2).size() == 0) {
            zz3T4 = zz3T2;
            boolean bl = zz3T4.size() > 0;
            return bl;
        }
        Object e = zz3T3.peek();
        Object e2 = zz3T2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zz3T<Node> zzYk(Node node) {
        zz3T<Node> zz3T2 = new zz3T<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zz3T2.push(node2);
        }
        return zz3T2;
    }

    private static Node zzZ(zz3T<Node> zz3T2, zz3T<Node> zz3T3) {
        Node node = null;
        while (zz3T2.peek() == zz3T3.peek()) {
            node = (Node)zz3T2.pop();
            zz3T3.pop();
            zz3T<Node> zz3T4 = zz3T2;
            if (zz3T4.size() != 0 && (zz3T4 = zz3T3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzYm9;
    }

    public void setCustomNodeId(int value) {
        this.zzYm9 = value;
    }

    private String zzYQD() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzYS.zzZ(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzZYM.zzUO(stringBuilder.toString());
    }

    public String toString() {
        return zzZYM.zzUO(zzZYM.zzY("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzYQD()));
    }

    public void dd() {
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

