/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.internal.zz12;
import com.aspose.words.internal.zz2B;
import com.aspose.words.internal.zz2C;
import com.aspose.words.internal.zz2D;
import com.aspose.words.internal.zz36;
import com.aspose.words.internal.zz3T;
import com.aspose.words.internal.zz5T;
import com.aspose.words.internal.zz5U;
import com.aspose.words.internal.zz7G;
import com.aspose.words.internal.zz7Z;
import com.aspose.words.internal.zz82;
import com.aspose.words.internal.zzKN;
import com.aspose.words.internal.zzL8;
import com.aspose.words.internal.zzYS;
import com.aspose.words.internal.zzYV;
import com.aspose.words.internal.zzZYM;
import com.aspose.words.zz3U;
import com.aspose.words.zz6;
import com.aspose.words.zz7;
import com.aspose.words.zz84;
import com.aspose.words.zz8U;
import com.aspose.words.zz90;
import com.aspose.words.zzBF;
import com.aspose.words.zzBW;
import com.aspose.words.zzCS;
import com.aspose.words.zzFB;
import com.aspose.words.zzJM;
import com.aspose.words.zzXZ;
import com.aspose.words.zzYD;
import com.aspose.words.zzYF5;
import com.aspose.words.zzYHP;
import com.aspose.words.zzYKJ;
import com.aspose.words.zzYL1;
import com.aspose.words.zzYLT;
import com.aspose.words.zzYM6;
import com.aspose.words.zzYOM;
import com.aspose.words.zzYPY;
import com.aspose.words.zzYR4;
import com.aspose.words.zzYV2;
import com.aspose.words.zzYYA;
import com.aspose.words.zzYZI;
import com.aspose.words.zzYZM;
import com.aspose.words.zzYZO;
import com.aspose.words.zzZ8S;
import com.aspose.words.zzZH;
import com.aspose.words.zzZHF;
import com.aspose.words.zzZHI;
import com.aspose.words.zzZIV;
import com.aspose.words.zzZJM;
import com.aspose.words.zzZKU;
import com.aspose.words.zzZNJ;
import com.aspose.words.zzZOG;
import com.aspose.words.zzZT8;
import com.aspose.words.zzZX1;
import com.aspose.words.zzZX6;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzZHF,
zzZHI,
zzZKU {
    private Document zzZda;
    private Node zzZbF;
    private Node zzZbE;
    private zzYR4 zzZKv;
    private Font zzZbD;
    private zz3T<zzYR4> zzZbC;
    private zz3T<zzZ> zzZbB;
    private zzYKJ zzZKu = zzYKJ.zzYhq();
    private zzYD zzZQN = new zzYD();
    private RowFormat zzZbA;
    private CellFormat zzZQM;
    private zz3T<zzYL1> zzZbz;
    private int zzZby = 0;
    private int zzZbx = -1;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) throws Exception {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() throws Exception {
        this.zzO(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() throws Exception {
        this.zzO(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) throws Exception {
        this.zzO(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) throws Exception {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZ(documentBuilder.getCurrentSection(), zzYF5.zzkI(headerFooterType), 0, 0);
    }

    private void zzO(int n, int n2, int n3, int n4) throws Exception {
        this.zzZda.ensureMinimum();
        Section section = (Section)this.zzZda.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzZ(section, 1, n3, n4);
    }

    private void zzZ(Section section, int n, int n2, int n3) throws Exception {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzYF5.zzkH(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZda, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZda));
            }
        }
        this.zzZ(story, n2, n3);
    }

    private void zzZ(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        this.zzX(paragraph, n2);
    }

    final void zzX(Paragraph paragraph, int n) {
        if (n == 0) {
            Paragraph paragraph2 = paragraph;
            this.zzY(paragraph2, paragraph2.getFirstChild());
            return;
        }
        if (n == -1) {
            this.zzY(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzZys().zzZpR() ? zzZ8S.zzT(this.zzZda, fieldName) : zzZ8S.zzS(this.zzZys(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzZ(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzZ(field, isAfter, false);
    }

    private boolean zzZ(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZIV zzZIV2 = field.getFormat().zzZo4();
        Inline inline = zzZIV2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzZ(inline.zz6H(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzZH.zzZ(this.zzZda, bookmarkName) : zzZH.zzY(this.zzZda, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzYQH() == 6) {
            this.zzY((Paragraph)node.zzYQW(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzCS.zza(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzY(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZ(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) throws Exception {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: characterIndex");
        }
        Row row = this.zzY6(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzX(cell.getFirstParagraph(), 0);
            return;
        }
        this.zzX(cell.getLastParagraph(), -1);
    }

    private void zzY(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzYQH() == 6) {
            this.zzZS(node);
        } else if (zzCS.zzm(node)) {
            Paragraph paragraph = zzCS.zza(node);
            if (paragraph == null) {
                throw new IllegalStateException("There is no paragraph next to the specified node.");
            }
            this.zzZS(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
        } else if (node.isComposite() && node.zzYQH() == 3) {
            Node node2 = ((CompositeNode)node).getChild(8, 0, true);
            if (node2 == null) {
                throw new IllegalStateException("The block level node doesn't contain paragraph.");
            }
            this.zzZS(node2);
        } else {
            throw new IllegalStateException("The node must be a block or an inline.");
        }
        if (this.isAtEndOfParagraph()) {
            this.zzZyJ();
            return;
        }
        if (!this.zzZyK()) {
            this.zzZyJ();
        }
    }

    private boolean zzZyK() {
        Node node = this.zzZys();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzZys(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzZ(inline.zz6H(), true);
            return true;
        }
        return false;
    }

    private void zzZyJ() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZ(documentBuilder.getCurrentParagraph().zzYFc(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) throws Exception {
        Row row = this.zzY6(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzZyw() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzZys().zzYm(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzYQO();
                this.zzX(paragraph, 0);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) throws Exception {
        this.zzz(text, false);
    }

    public void writeln(String text) throws Exception {
        this.zzz(text, true);
    }

    public void writeln() throws Exception {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() throws Exception {
        Paragraph paragraph = this.getCurrentParagraph();
        zzYLT zzYLT2 = new zzYLT(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzZda, this.zzZyC(), this.zzZyD());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzY(this.zzZys(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzYLT2.dispose();
        }
        if (this.getDocument().zzZza()) {
            zzYV2.zzX(paragraph, this.getDocument().zzZzg());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzZyI() throws Exception {
        zzYR4 zzYR42;
        Run run;
        Run run2;
        Cloneable cloneable;
        Node node = this.zzZys();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzQS(false);
        } else {
            run2 = run = (Run)node.zzvW(21);
        }
        if (run2 == null && zzYS.zzJ(node, paragraph.zzZ7W())) {
            run = paragraph.zzZ7W();
        }
        if (run != null) {
            cloneable = run.zz6H();
            zzYR42 = (zzYR4)((zz6)cloneable).zzhP();
        } else {
            cloneable = paragraph.zzYFc();
            zzYR42 = (zzYR4)((zz6)cloneable).zzhP();
        }
        zzYR4 zzYR43 = zzYR42;
        Paragraph paragraph2 = new Paragraph(this.zzZda, this.zzZyC(), zzYR43);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzYLT zzYLT2 = new zzYLT(this.zzZda);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzY(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzYLT2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() throws Exception {
        zzYM6.zzU(this);
    }

    public void insertBreak(int breakType) throws Exception {
        this.zzc(breakType, true);
    }

    final void zzc(int n, boolean bl) throws Exception {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzWg(bl)) {
                    this.zzP1(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzWg(bl)) {
                    this.zzP1(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzWg(bl)) {
                    this.zzGv(1);
                }
                return;
            }
            case 5: {
                if (this.zzWg(bl)) {
                    this.zzGv(2);
                }
                return;
            }
            case 3: {
                if (this.zzWg(bl)) {
                    this.zzGv(0);
                }
                return;
            }
            case 6: {
                if (this.zzWg(bl)) {
                    this.zzGv(3);
                }
                return;
            }
            case 7: {
                if (this.zzWg(bl)) {
                    this.zzGv(4);
                }
                return;
            }
            case 8: {
                this.zzP1(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) throws Exception {
        if (!zz7Z.zzXE(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzZYM.zzY("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        return zzCS.zzZ(fieldType, updateField, this.zzZyD(), this.zzZys(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        return zzCS.zzZ(fieldCode, this.zzZyD(), this.zzZys(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) throws Exception {
        return zzCS.zzZ(fieldCode, fieldValue, this.zzZyD(), this.zzZys(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) throws Exception {
        zzYS.zzY((Object)displayText, "displayText");
        zzYS.zzY((Object)urlOrBookmark, "hrefOrBookmark");
        zzZX6 zzZX62 = this.zzY(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzZX62.zzY(documentBuilder.zzb(88, true));
        return zzCS.zzZ(zzZX62.getStart(), zzZX62.getSeparator(), zzZX62.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzGu(70);
        if (zz7Z.zzXE(name)) {
            this.startBookmark(name);
        }
        this.zzP0(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzGt(70);
        String string = zz7Z.zzXE(fieldValue) ? fieldValue : FormField.zzYRn;
        Run run = new Run(this.zzZda, string, this.zzZyD());
        this.insertNode(run);
        Node node = this.zzb(70, true);
        if (zz7Z.zzXE(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzZT(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzY((Paragraph)node.zzYQW(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzGu(71);
        if (zz7Z.zzXE(name)) {
            this.startBookmark(name);
        }
        this.zzP0(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzb(71, false);
        if (zz7Z.zzXE(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZT(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzGu(83);
        if (zz7Z.zzXE(name)) {
            this.startBookmark(name);
        }
        this.zzP0(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzb(83, false);
        if (zz7Z.zzXE(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZT(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) throws Exception {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) throws Exception {
        Footnote footnote = new Footnote((DocumentBase)this.zzZda, footnoteType);
        footnote.getFont().setStyleIdentifier(zzCS.zzKb(footnoteType));
        if (zz7Z.zzXE(referenceMark)) {
            footnote.setReferenceMark(referenceMark);
        }
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZda);
        paragraph.getParagraphFormat().setStyleIdentifier(zzCS.zzKa(footnoteType));
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZda, '\u0002', new zzYR4()) : new Run(this.zzZda, footnote.getReferenceMark(), new zzYR4());
        inline.getFont().setStyleIdentifier(zzCS.zzKb(footnoteType));
        paragraph.appendChild(inline);
        if (zz7Z.zzXE(footnoteText)) {
            Node node = this.zzZys();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzZS(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzZJ(zz2B zz2B2) throws Exception {
        return this.zzZ(zz2B2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZJ(zz2B.zzY(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzZ(zz2B zz2B2, double d, double d2) throws Exception {
        return this.zzZ(zz2B2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzZ(zz2B.zzY(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zz2D zz2D2 = new zz2D();){
            zzYV.zzZ(image, zz2D2);
            Shape shape = this.zzZ(zz2D2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzYS.zzZ(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zz7G.zzXn(fileName);
        try {
            Shape shape = this.zzZ((zz2B)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zz2B)object).close();
            }
        }
    }

    private Shape zzZ(zz2B zz2B2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zz2B2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzYS.zzS(zz2B2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZ(zz2B.zzY(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl = zzKN.zzZA(imageBytes);
        boolean bl2 = this.zzZda.getCompatibilityOptions().getMswVersion() > 12 || this.zzZda.getCompatibilityOptions().getMswVersion() == 0;
        if (bl2) {
            shape = new Shape((DocumentBase)this.zzZda, 0);
            zz84 zz842 = new zz84();
            zz842.zzZ(zzBF.zzPr("rect"));
            zz842.zzZ(new zzJM());
            zz842.zzZF8().zzZXx().zzY(this.zzZda);
            zz8U zz8U2 = new zz8U();
            zz8U2.zzY(new zz90(this.zzZda.zzZyU(), ""));
            zz8U2.zzZ(new zzFB());
            zz842.zzZ(zz8U2);
            shape.zzEK(75);
            shape.zzU(zz842);
            if (bl) {
                zz842.zzZF8().zzZXx().setExtensions(new zz82<zzBW>());
                zzBW zzBW2 = zzBW.zzZ(imageBytes, this.zzZda);
                zz842.zzZF8().zzZXx().getExtensions().zzV(zzBW2.getUri(), zzBW2);
            }
        } else {
            shape = new Shape((DocumentBase)this.zzZda, 75);
        }
        shape.zzZ(this.zzZyD());
        if (bl) {
            imageBytes = shape.getImageData().zzZ(imageBytes, new zzYOM(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), bl2 ? 6 : 2);
        }
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzn(width, height);
        return shape;
    }

    private Shape zzZ(zz2B zz2B2, String string, boolean bl, zz2B zz2B3) throws Exception {
        zzYZM zzYZM2 = zzYZM.zzF6(string);
        Shape shape = this.zzZ(zz2B3, bl, zzYZM2, null);
        zzYZO zzYZO2 = zzYZI.zzZ(zz2B2, string, bl);
        return DocumentBuilder.zzZ(null, false, shape, zzYZM2.zzY9M, zzYZO2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzZ(zz2B.zzY(stream), progId, asIcon, zz2B.zzY(presentation));
    }

    private Shape zzZ(String string, boolean bl, boolean bl2, zz2B zz2B2) throws Exception {
        zzYZM zzYZM2 = zzYZM.zzF5(zz2C.zzVZ(string));
        return this.zzZ(string, bl, bl2, zz2B2, zzYZM2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzZ(fileName, isLinked, asIcon, zz2B.zzY(presentation));
    }

    private Shape zzZ(String string, String string2, boolean bl, boolean bl2, zz2B zz2B2) throws Exception {
        zzYZM zzYZM2 = zzYZM.zzF6(string2);
        return this.zzZ(string, bl, bl2, zz2B2, zzYZM2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzZ(fileName, progId, isLinked, asIcon, zz2B.zzY(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYZM zzYZM2 = zzYZM.zzF5(zz2C.zzVZ(fileName));
        return this.zzZ(fileName, isLinked, iconFile, iconCaption, zzYZM2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYZM zzYZM2 = zzYZM.zzF6(progId);
        return this.zzZ(fileName, isLinked, iconFile, iconCaption, zzYZM2);
    }

    private Shape zzZ(zz2B zz2B2, String string, String string2, String string3) throws Exception {
        zzYZM zzYZM2 = zzYZM.zzF6(string);
        Shape shape = this.zzZ(string2, string3, zzYZM2);
        zzYZO zzYZO2 = zzYZI.zzZ(zz2B2, string, true);
        return DocumentBuilder.zzZ(null, false, shape, zzYZM2.zzY9M, zzYZO2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzZ(zz2B.zzY(stream), progId, iconFile, iconCaption);
    }

    final Shape zzZ(zzZNJ zzZNJ2, zz2B zz2B2) throws Exception {
        Shape shape = this.zzZI(zz2B2);
        shape.zzEK(201);
        shape.getOleFormat().zzY(zzZNJ2.zzZcx());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzZ(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zzZOG zzZOG2 = new zzZOG();
        zzZOG2.zzV3(useBuilderFormatting);
        zzZOG2.zzV2(useBuilderFormatting);
        this.zzZ(html, zzZOG2);
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        return zzCS.zzZ(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return zzCS.zzZ(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzXZ zzXZ2 = new zzXZ();
        return zzXZ2.zzZ(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYHP(this).zzZ(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYHP(this).zzZ(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZda, 75);
        shape.zzZ(this.zzZyD());
        shape.zzQ7(true);
        shape.getSignatureLine().zzZ(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzn(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzd(this.zzZda);
        this.insertNode(shape);
        return shape;
    }

    private void zzZ(String string, zzZOG zzZOG2) throws Exception {
        if (this.zzZyH()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzP2(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzZJM zzZJM2 = zzCS.zzZ(string, zzZOG2, this);
        zzZJM2.zzKQ();
    }

    private boolean zzZyH() {
        boolean bl = false;
        if (this.zzZys().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzZys().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzP2(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() throws Exception {
        if (this.zzZyw() == null) {
            this.startTable();
        }
        if (this.zzZyw().zzYj6() == 1) {
            this.zzZyw().zzYj9();
        }
        if (this.zzZyw().zzYj6() == 3) {
            this.zzZyw().zzYj7();
        }
        return this.zzZyw().zzYj8();
    }

    public Table startTable() throws Exception {
        this.zzZbz.push(new zzYL1(this));
        return this.zzZyw().startTable();
    }

    public Table endTable() {
        if (this.zzZyw() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzZyw().endTable();
        this.zzZbz.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzZyw() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzZyw().endRow();
        if (this.zzZbD != null && this.zzZbD.getHidden()) {
            row.zz6F().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) throws Exception {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZda, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) throws Exception {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZda, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) throws Exception {
        Cell cell = this.zzZyv();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        Paragraph paragraph = cell2.getFirstParagraph();
        if (paragraph == null) {
            paragraph = new Paragraph(this.getDocument());
            cell2.appendChild(paragraph);
        }
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZda, bookmarkName);
        paragraph.insertAfter(bookmarkStart, null);
        int n = cell.zzem();
        bookmarkStart.zzPS(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) throws Exception {
        Cell cell = this.zzZyv();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzem();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZda, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzPR(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() throws Exception {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZda);
        this.zzZbx = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() throws Exception {
        if (this.zzZbx == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZda, this.zzZbx);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) throws Exception {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZda, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) throws Exception {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) throws Exception {
        zzYS.zzY((Object)importFormatOptions, "ImportFormatOptions");
        return zz3U.zzZ(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzZda;
    }

    public void setDocument(Document value) throws Exception {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZda) {
            return;
        }
        this.zzZda = value;
        this.zzZS(null);
        this.zzZKv = new zzYR4();
        this.zzZbC = null;
        this.zzZbD = null;
        this.zzZbz = new zz3T();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZbD == null) {
            DocumentBuilder documentBuilder = this;
            this.zzZbD = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzZbD;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) throws Exception {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) throws Exception {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) throws Exception {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzZbA == null) {
            this.zzZbA = new RowFormat(this);
        }
        return this.zzZbA;
    }

    public CellFormat getCellFormat() {
        if (this.zzZQM == null) {
            this.zzZQM = new CellFormat(this);
        }
        return this.zzZQM;
    }

    final void zzZU(Node node) throws Exception {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzYR4 zzYR42 = this.getCurrentParagraph().zzYFc();
        this.zzZyt().push(new zzZ(this.zzZyD(), (zzYR4)zzYR42.zzhP()));
    }

    public void popFont() {
        zz3T<zzZ> zz3T2 = this.zzZyt();
        if (zz3T2.size() > 0) {
            zzZ zzZ100 = (zzZ)this.zzZyt().pop();
            this.zzZ(zzZ100.zz6H(), false);
            this.getCurrentParagraph().zzH(zzZ100.zzZyr());
        }
    }

    final void zzZyG() {
        this.zzZyu().push(this.zzZyD());
    }

    final void zzZyF() {
        zz3T<zzYR4> zz3T2 = this.zzZyu();
        if (zz3T2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzZ((zzYR4)documentBuilder.zzZyu().pop(), false);
        }
    }

    final zzZX6 zzY(String string, boolean bl, String string2, String string3) throws Exception {
        FieldStart fieldStart = this.zzGu(88);
        zzZX1 zzZX12 = new zzZX1();
        zzZX12.setTarget(string2);
        zzZX12.setScreenTip(string3);
        if (bl) {
            zzZX12.setSubAddress(string);
        } else {
            zzZX12.setAddress(zz5T.zzXa(string));
            zzZX12.setSubAddress(zz5T.zzX9(string));
        }
        this.zzP0(zzZX12.toString());
        FieldSeparator fieldSeparator = this.zzGt(88);
        return new zzZX6(fieldStart, fieldSeparator, null);
    }

    final zzZX6 zzN(String string, String string2, String string3) throws Exception {
        boolean bl = zz5T.zzWZ(string);
        String string4 = bl ? zz5T.zzX9(string) : string;
        return this.zzY(string4, bl, string2, string3);
    }

    final FieldEnd zzZyE() throws Exception {
        return this.zzb(88, true);
    }

    final zzYR4 zzZyD() {
        zzYR4 zzYR42 = this.zzZKv;
        return (zzYR4)zzYR42.zzhP();
    }

    final zzYYA zzZyC() {
        zzYYA zzYYA2 = this.getCurrentParagraph().zz6J();
        return (zzYYA)zzYYA2.zzhP();
    }

    final zzYKJ zzZyB() {
        zzYKJ zzYKJ2 = this.zz6F();
        return (zzYKJ)zzYKJ2.zzhP();
    }

    final zzYD zzZyA() {
        zzYD zzYD2 = this.zzen();
        return (zzYD)zzYD2.zzhP();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzZys(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzZys().getNodeType() == 8;
    }

    private void zzz(String string, boolean bl) throws Exception {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzYF5.zzAM(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzOZ(string2.substring(n4, n4 + n2));
                }
                switch (this.zzZby) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzP1(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzOZ(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    private Run zzP1(String string) throws Exception {
        Run run = new Run(this.zzZda, string, this.zzZyD());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) throws Exception {
        if (this.zzZyw() != null && this.zzZyw().zzYj6() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzZys().getParentNode().insertBefore(node, this.zzZys());
    }

    final void zzGw(int n) throws Exception {
        this.zzWg(true);
        this.zzGv(n);
    }

    private void zzGv(int n) throws Exception {
        this.insertParagraph();
        zzYLT zzYLT2 = new zzYLT(this.getDocument());
        try {
            zzYPY zzYPY2 = this.getCurrentSection().zzYLD();
            zzYPY zzYPY3 = (zzYPY)zzYPY2.zzhP();
            Section section = new Section(this.zzZda, zzYPY3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZda));
            this.zzZda.insertAfter(section, this.getCurrentSection());
            section.getBody().zzY(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzYLT2.dispose();
        }
    }

    final FieldStart zzGu(int n) throws Exception {
        return zzCS.zzZ(n, this.zzZyD(), this.zzZys(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzP0(String string) throws Exception {
        return zzCS.zzY(string, this.zzZyD(), this.zzZys(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzb(int n, boolean bl) throws Exception {
        return zzCS.zzY(n, bl, this.zzZyD(), this.zzZys(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzGt(int n) throws Exception {
        return zzCS.zzY(n, this.zzZyD(), this.zzZys(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzZT(Node node) throws Exception {
        FormField formField = new FormField((DocumentBase)this.zzZda, new zzZT8(), this.zzZyD());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzWg(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzZyw() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzY6(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzOZ(String string) throws Exception {
        if (this.zzOY(string)) {
            zz36 zz362 = new zz36(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zz12 zz122 : zz362.zzZd(this.getParagraphFormat().getBidi())) {
                zz7 zz710 = zz7.zzYS(zz122.zzn1());
                zzYR4 zzYR42 = this.zzZyD();
                zzYR42.zzN(265, zz710);
                if (zz122.zzmX()) {
                    zzYR42.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZda, zz122.getText(), zzYR42);
                this.insertNode(run);
            }
            return;
        }
        this.zzP1(string);
    }

    private boolean zzOY(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zz5U.zz6(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzZ(zzYR4 zzYR42, boolean bl) {
        zzYR4 zzYR43;
        if (bl) {
            zzYR4 zzYR44 = zzYR42;
            zzYR43 = (zzYR4)zzYR44.zzhP();
        } else {
            zzYR43 = zzYR42;
        }
        this.zzZKv = zzYR43;
    }

    final void zzZyz() {
        this.zzZKv.clear();
    }

    final void zzZyy() {
        if (this.zzZyv() != null) {
            zzYD zzYD2;
            zzYD zzYD3 = zzYD2 = this.zzZyv().zzen();
            this.zzZQN = (zzYD)zzYD3.zzhP();
            zzYD2.zzY(this.zzZQN);
        }
    }

    private Shape zzZ(String string, boolean bl, boolean bl2, zz2B zz2B2, zzYZM zzYZM2) throws Exception {
        if (zzYZM2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzZ(zz2B2, bl2, zzYZM2, string);
        zzYZO zzYZO2 = zzYZI.zzZ(string, bl, bl2, zzYZM2);
        return DocumentBuilder.zzZ(string, bl, shape, zzYZM2.zzY9M, zzYZO2);
    }

    private Shape zzZ(String string, boolean bl, String string2, String string3, zzYZM zzYZM2) throws Exception {
        if (zzYZM2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zz2C.zzW2(string);
        }
        Shape shape = string2 != null ? this.zzZv(string2, string3) : this.zzZ(null, string3, zzYZM2);
        zzYZO zzYZO2 = zzYZI.zzZ(string, bl, true, zzYZM2);
        return DocumentBuilder.zzZ(string, bl, shape, zzYZM2.zzY9M, zzYZO2);
    }

    private static Shape zzZ(String string, boolean bl, Shape shape, String string2, zzYZO zzYZO2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzEK(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzY(zzYZO2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzZ(zz2B zz2B2, boolean bl, zzYZM zzYZM2, String string) throws Exception {
        if (zzYZM2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zz2B2 != null) {
            return this.zzZI(zz2B2);
        }
        if (!bl) {
            return this.zzYz(zzYZI.zzYHh().get("normal"));
        }
        String string2 = string != null ? zz2C.zzW2(string) : zzYZI.zzF1(zzYZM2.zzY9I);
        return this.zzZ(zzYZM2, string2);
    }

    private Shape zzZ(String string, String string2, zzYZM zzYZM2) throws Exception {
        if (zzYZM2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzYZI.zzF1(zzYZM2.zzY9I);
        }
        if (string != null) {
            return this.zzZv(string, string2);
        }
        return this.zzZ(zzYZM2, string2);
    }

    private Shape zzZ(zzYZM zzYZM2, String string) throws Exception {
        if (zzYZM2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzYZI.zzF2(zzYZM2.zzY9I);
        zzL8 zzL82 = new zzL8(byArray, null, string, this.getDocument().zzZzm());
        return this.zzYz(zzL82.zzHl());
    }

    private Shape zzZv(String string, String string2) throws Exception {
        zzL8 zzL82 = new zzL8(string, string2, this.getDocument().zzZzm());
        return this.zzYz(zzL82.zzHl());
    }

    private Shape zzZI(zz2B zz2B2) throws Exception {
        byte[] byArray = zzYS.zzS(zz2B2);
        return this.zzYz(byArray);
    }

    private Shape zzYz(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZda, 1);
        shape.zzEK(75);
        shape.zzZ(this.zzZyD());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzn(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    final boolean zzZIi() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzZyx() {
        return this.zzZby;
    }

    final void zzGs(int n) {
        this.zzZby = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzZys();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzZys();
        }
        return (Paragraph)this.zzZys().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzYL1 zzZyw() {
        zz3T<zzYL1> zz3T2 = this.zzZbz;
        if (zz3T2.size() > 0) {
            return (zzYL1)this.zzZbz.peek();
        }
        return null;
    }

    private Cell zzZyv() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzZos();
    }

    private zz3T<zzYR4> zzZyu() {
        if (this.zzZbC == null) {
            this.zzZbC = new zz3T();
        }
        return this.zzZbC;
    }

    private zz3T<zzZ> zzZyt() {
        if (this.zzZbB == null) {
            this.zzZbB = new zz3T();
        }
        return this.zzZbB;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZKv.zzQ5(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZf(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZf(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZKv.zzN(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzYF3()) {
            this.getCurrentParagraph().zzYFc().zzN(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZKv.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZKv.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzYF3()) {
            this.getCurrentParagraph().zzYFc().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zz6F().zzQ5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zz6F().zzQ4(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zz6F().zzQ3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zz6F().zzN(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zz6F().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zz6F().clear();
        zzYKJ.zzYhq().zzY(this.zz6F());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzen().zzQ5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzen().zzQ4(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzen().zzQ3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzYS.zzZ(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzZyv() != null ? this.zzZyv().getCellFormat() : this.getCellFormat();
            border.zzZ(cellFormat);
        }
        this.zzen().zzN(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzen().clear();
    }

    private Node zzZys() {
        Node node = this.zzZbF != null && this.zzZbF.getParentNode() == null ? this.zzZbE : this.zzZbF;
        if (node != null && node.zzYQH() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzZS(Node node) {
        this.zzZbF = node;
        if (this.zzZbF != null) {
            this.zzZbE = this.zzZbF.getParentNode();
        }
    }

    private zzYKJ zz6F() {
        if (this.zzZyw() != null && this.zzZyw().zzYj6() == 1) {
            return this.zzZKu;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zz6F();
        }
        return this.zzZKu;
    }

    private zzYD zzen() {
        if (this.zzZyw() != null && this.zzZyw().zzYj6() != 3) {
            return this.zzZQN;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzZos().zzen();
        }
        return this.zzZQN;
    }

    static final class zzZ {
        private zzYR4 zzZKv;
        private zzYR4 zzZbw;

        public zzZ(zzYR4 zzYR42, zzYR4 zzYR43) {
            this.zzZKv = zzYR42;
            this.zzZbw = zzYR43;
        }

        public final zzYR4 zz6H() {
            return this.zzZKv;
        }

        public final zzYR4 zzZyr() {
            return this.zzZbw;
        }
    }
}

