/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz2B;
import com.aspose.words.internal.zz2D;
import com.aspose.words.internal.zz2E;
import com.aspose.words.internal.zzFF;
import com.aspose.words.internal.zzFH;
import com.aspose.words.internal.zzFJ;
import com.aspose.words.internal.zzPS;
import com.aspose.words.internal.zzUB;
import com.aspose.words.internal.zzY8;
import com.aspose.words.internal.zzYS;
import com.aspose.words.internal.zzZY9;
import com.aspose.words.internal.zzZYM;
import com.aspose.words.zzMU;
import com.aspose.words.zzYEO;
import com.aspose.words.zzYOU;
import com.aspose.words.zzYZ9;
import com.aspose.words.zzYZA;
import com.aspose.words.zzYZB;
import com.aspose.words.zzYZC;
import com.aspose.words.zzZ1W;
import com.aspose.words.zzZ1Z;
import com.aspose.words.zzZUR;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzZ(zz2B zz2B2, zz2B zz2B3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzYS.zzY((Object)zz2B2, "srcStream");
        zzYS.zzY((Object)zz2B3, "dstStream");
        zzYS.zzY((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzY(zz2B2, zz2B3, certificateHolder, signOptions);
        zz2B3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzZ(zz2B.zzY(srcStream), (zz2B)zz2B.zzX(dstStream), certHolder, signOptions);
    }

    private static void zzY(zz2B zz2B2, zz2B zz2B3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzX(digitalSignature);
        }
        if (zzZUR.zzZC(zz2B2)) {
            DigitalSignatureUtil.zzZ(zz2B2, zz2B3, digitalSignature, true);
            return;
        }
        zzZUR zzZUR2 = new zzZUR();
        zz2B zz2B4 = zz2B2;
        zzZUR zzZUR3 = zzZUR2;
        FileFormatInfo fileFormatInfo = zzZUR2.zzY(zz2B4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzPS zzPS2 = new zzPS(zz2B2);
                int n = fileFormatInfo.zzZkj() == 1 ? 1 : 2;
                zzYOU.zzZ(zzPS2, digitalSignature, n);
                zz2B3.zzl(0L);
                zzPS2.zzL(zz2B3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzZ(fileFormatInfo.zzZki(), zz2B3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzZ(zz2B2, zz2B3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzZ(zz2B2, zz2B3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzYS.zzZ(srcFileName, "srcFileName");
        zzYS.zzZ(dstFileName, "dstFileName");
        try (zz2E zz2E2 = zzYS.zzY(srcFileName, 3, 1);){
            try (zz2E zz2E3 = zzYS.zzY(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzZ((zz2B)zz2E2, (zz2B)zz2E3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzZY9 zzZY92 = zz2B.zzX(dstStream);
        zz2B zz2B2 = zz2B.zzY(srcStream);
        DigitalSignatureUtil.zzZ(zz2B2, (zz2B)zzZY92, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zz2E zz2E2 = zzYS.zzY(srcFileName, 3, 1);){
            try (zz2E zz2E3 = zzYS.zzY(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzV(zz2E2, zz2E3);
            }
            return;
        }
    }

    private static void zzV(zz2B zz2B2, zz2B zz2B3) throws Exception {
        zzZUR zzZUR2 = new zzZUR();
        zz2B zz2B4 = zz2B2;
        zzZUR zzZUR3 = zzZUR2;
        FileFormatInfo fileFormatInfo = zzZUR2.zzY(zz2B4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzPS zzPS2 = new zzPS(zz2B2);
                zzPS2.zzKO().zz3("_xmlsignatures");
                zzPS2.zzKO().zz3("_signatures");
                zz2B3.zzk(0L);
                zzPS2.zzL(zz2B3);
                zz2B zz2B5 = zz2B3;
                zz2B5.zzl(zz2B5.zzV3());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzFJ zzFJ2 = new zzFJ(zz2B2);
                zzFH zzFH2 = zzFJ2.zzZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzFH2 != null) {
                    for (zzFF zzFF2 : zzFH2.zzAT()) {
                        String string = zzFH2.zzZ(zzFF2);
                        zzFJ2.zzAU().remove(string);
                    }
                    zzFJ2.zzAU().remove(zzFH2.getName());
                    zzFF zzFF3 = zzFJ2.zzAT().zzYf("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzFJ2.zzAT().remove(zzFF3.getId());
                    zzFJ2.zzAX();
                }
                zz2B3.zzk(0L);
                zzFJ2.zzL(zz2B3);
                zz2B zz2B6 = zz2B3;
                zz2B6.zzl(zz2B6.zzV3());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzV(zz2B.zzY(srcStream), zz2B.zzX(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zz2E zz2E2 = zzYS.zzY(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzZN(zz2E2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzZN(zz2B zz2B2) throws Exception {
        if (zzZUR.zzZC(zz2B2)) {
            return DigitalSignatureUtil.zzZM(zz2B2);
        }
        zzZUR zzZUR2 = new zzZUR();
        zz2B zz2B3 = zz2B2;
        zzZUR zzZUR3 = zzZUR2;
        FileFormatInfo fileFormatInfo = zzZUR2.zzY(zz2B3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zz2B2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzZN(zz2B.zzY(stream));
    }

    static zz2D zzZ(zzPS zzPS2, String string) throws Exception {
        zzMU zzMU2 = new zzMU(zzPS2);
        if (zzMU2.zz13()) {
            zz2D zz2D2 = zzMU2.zzT2(string);
            return zz2D2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzNh(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzZYM.zzY("Unexpected digest algorithm: {0}.", n));
    }

    static String zzw(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzNh(n);
    }

    private static void zzZ(zz2B zz2B2, zz2B zz2B3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzFJ zzFJ2 = new zzFJ(zz2B2);
        zzYZB zzYZB2 = bl ? new zzYZ9(zzFJ2) : new zzYZA(zzFJ2);
        zzYZB2.zzY(digitalSignature);
        zz2B3.zzl(0L);
        zzFJ2.zzL(zz2B3);
    }

    private static void zzZ(zz2B zz2B2, zz2B zz2B3, DigitalSignature digitalSignature) throws Exception {
        zzZ1Z zzZ1Z2 = new zzZ1Z(zz2B2);
        zzZ1W zzZ1W2 = new zzZ1W(zzZ1Z2);
        zzZ1W2.zzY(digitalSignature);
        zz2B3.zzl(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zz2B zz2B4 = zz2B3;
        zzZ1Z zzZ1Z3 = zzZ1Z2;
        zzZ1Z3.zzZ(zz2B4, string, null);
    }

    private static void zzZ(zzPS zzPS2, zz2B zz2B2, DigitalSignature digitalSignature, String string) throws Exception {
        zz2D zz2D2 = DigitalSignatureUtil.zzZ(zzPS2, string);
        zz2D zz2D3 = new zz2D();
        DigitalSignatureUtil.zzZ((zz2B)zz2D2, (zz2B)zz2D3, digitalSignature, false);
        zzPS zzPS3 = zzMU.zzX(zz2D3, string);
        zzPS3.zzL(zz2B2);
    }

    private static DigitalSignatureCollection zzZM(zz2B zz2B2) throws Exception {
        zz2B2.zzk(0L);
        zzFJ zzFJ2 = new zzFJ(zz2B2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzFH zzFH2 = zzFJ2.zzZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzFH2 != null) {
            for (zzFF zzFF2 : zzFH2.zzAT()) {
                String string = zzFH2.zzZ(zzFF2);
                zzFH zzFH3 = zzFJ2.zzYk(string);
                zzFH zzFH4 = zzFJ2.zzZ(zzFH3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzY8 zzY82 = zzUB.zzs(zzFH4.zzAQ().zzXV());
                zzYEO.zzZ(zzFH3.zzSJ(), zzY82, new zzYZC(zzFJ2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

