/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzYS;
import com.aspose.words.zz3K;
import com.aspose.words.zzCS;
import com.aspose.words.zzYLT;
import com.aspose.words.zzYV2;
import com.aspose.words.zzZ6P;
import com.aspose.words.zzZ77;
import com.aspose.words.zzZI2;
import com.aspose.words.zzZI3;
import com.aspose.words.zzZII;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzZI2,
Iterable<T> {
    private Node zzZKF;
    private Node zzZKE;
    private Node zzZKD;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() throws Exception {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zz6Y() {
        return this.zz6V() != null;
    }

    final boolean zz6X() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zz6W() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzZII) {
                return true;
            }
            CompositeNode compositeNode = zzYS.zzZ((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zz6W()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzZKF;
    }

    public Node getLastChild() {
        return this.zzZKE;
    }

    final Node zz6V() {
        return zzCS.zzT(this.getFirstChild(), false);
    }

    final Node zz6U() {
        return zzCS.zzS(this.getLastChild(), false);
    }

    final CompositeNode zz6T() {
        return (CompositeNode)zzCS.zzT(this.getFirstChild(), true);
    }

    final CompositeNode zz6S() {
        return (CompositeNode)zzCS.zzS(this.getLastChild(), true);
    }

    final Node zz6R() {
        Node node;
        for (node = this.getFirstChild(); node != null && zzCS.zzm(node); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zz6Q() {
        Node node;
        for (node = this.getLastChild(); node != null && zzCS.zzm(node); node = node.getPreviousSibling()) {
        }
        return node;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzZ(boolean bl, zzZI3 zzZI32) {
        CompositeNode compositeNode = (CompositeNode)super.zzZ(bl, zzZI32);
        ((CompositeNode)super.zzZ(bl, zzZI32)).zzZKE = null;
        compositeNode.zzZKF = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzE(node.zzZ(true, zzZI32));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzK(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzK(StringBuilder stringBuilder) {
        this.zzJ(stringBuilder);
        zzYS.zzY(stringBuilder, this.zz6P());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzY(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzCS.zzJW(nodeType);
            Node node2 = node = bl ? this.zz6V() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzYQQ() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zz3K.zzX(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zz3K.zzW(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZ77(this);
    }

    public Node appendChild(Node newChild) throws Exception {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) throws Exception {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) throws Exception {
        return this.zzZ(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) throws Exception {
        return this.zzZ(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzZ(oldChild, this, null, 1);
        if (documentBase.zzZza() && zzYV2.zzXd(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzZ(nodeChangingArgs);
        }
        Node node = this.zzD(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzY(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzZ6P.zzm(this.getFirstChild(), null);
    }

    public void removeSmartTags() throws Exception {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzE(Node node) {
        node.getParentNode();
        if (this.zzZKE == null) {
            node.zzYo(null);
            node.zzYp(null);
            this.zzZKF = node;
        } else {
            node.zzYo(this.zzZKE);
            node.zzYp(null);
            this.zzZKE.zzYp(node);
        }
        this.zzZKE = node;
        node.zzYn(this);
        return node;
    }

    final void zzZ(Node node, Node node2, Node node3) throws Exception {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzY(Node node, Node node2, Node node3) throws Exception {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzY(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (zzCS.zzm(node2)) continue;
            if (zzCS.zzV(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zz6P().length();
    }

    String zz6P() {
        return "";
    }

    final String zz6O() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzJ(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzJ(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzK(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzZ(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzY(visitor));
    }

    abstract int zzZ(DocumentVisitor var1) throws Exception;

    abstract int zzY(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzS(Node var1);

    final Node zzZ(Node node, Node node2, boolean bl) throws Exception {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzYm(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzS(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzYLT(documentBase);
            try {
                compositeNode.removeChild(node);
            }
            finally {
                ((zzYLT)object).dispose();
            }
        }
        if ((object = documentBase.zzZ(node, null, this, 0)) != null) {
            documentBase.zzZ((NodeChangingArgs)object);
        }
        if (this.zzZKE == null) {
            node.zzYo(null);
            node.zzYp(null);
            this.zzZKF = node;
            this.zzZKE = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzY(node, node2);
            } else {
                this.zzX(node, this.zzZKF);
            }
        } else if (node2 != null) {
            this.zzX(node, node2);
        } else {
            this.zzY(node, this.zzZKE);
        }
        node.zzYn(this);
        if (object != null) {
            documentBase.zzY((NodeChangingArgs)object);
        }
        if (documentBase.zzZza()) {
            zzYV2.zzZ(node, compositeNode, node3);
        }
        return node;
    }

    private void zzY(Node node, Node node2) {
        Node node3 = node2.zzYQK();
        node.zzYo(node2);
        node.zzYp(node3);
        node2.zzYp(node);
        if (node3 == null) {
            this.zzZKE = node;
            return;
        }
        node3.zzYo(node);
    }

    private void zzX(Node node, Node node2) {
        Node node3 = node2.zzYQJ();
        node.zzYo(node3);
        node.zzYp(node2);
        node2.zzYo(node);
        if (node3 == null) {
            this.zzZKF = node;
            return;
        }
        node3.zzYp(node);
    }

    private Node zzD(Node node) {
        if (node == this.zzZKF) {
            if (this.zzZKF == this.zzZKE) {
                this.zzZKF = null;
                this.zzZKE = null;
            } else {
                this.zzZKF = node.zzYQK();
                this.zzZKF.zzYo(null);
            }
        } else {
            Node node2 = node.zzYQJ();
            Node node3 = node.zzYQK();
            node2.zzYp(node3);
            if (node3 == null) {
                this.zzZKE = node2;
            } else {
                node3.zzYo(node2);
            }
        }
        node.zzYp(null);
        node.zzYo(null);
        node.zzYn(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzZKD = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZKD;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

