/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zz3R;
import com.aspose.words.internal.zzYS;
import com.aspose.words.zz5X;
import com.aspose.words.zz73;
import com.aspose.words.zz8N;
import com.aspose.words.zz99;
import com.aspose.words.zzFO;
import com.aspose.words.zzG9;
import com.aspose.words.zzGC;
import com.aspose.words.zzH4;
import com.aspose.words.zzJ8;
import com.aspose.words.zzZKL;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzJ8 zzZPE;

    ChartSeriesCollection(zzJ8 dmlChart) {
        this.zzZPE = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZPE.zzZWV().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZPE.zzZWV().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZPE.zzZWV().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZPE.zzZWV().clear();
        this.zzYn(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, values);
        chartSeries.zzaB().zzW(ChartSeriesCollection.zzL(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, yValues);
        chartSeries.zzaB().zzW(ChartSeriesCollection.zzW(xValues));
        return chartSeries;
    }

    private ChartSeries zzZ(String string, zz3R[] zz3RArray, double[] dArray) {
        if (zz3RArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zz3RArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zz3RArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(string, dArray);
        chartSeries.zzaB().zzW(ChartSeriesCollection.zzZ(zz3RArray));
        if (!this.zzZPE.zzZWO()) {
            this.zzYn(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzZ(seriesName, zz3R.zzZ(dates), values);
    }

    private void zzYn(boolean bl) {
        zzZKL zzZKL2 = zzYS.zzZ((Object)this.zzZPE, zzZKL.class);
        if (zzZKL2 != null && zzZKL2.zzZYa().zzbI()) {
            zzZKL2.zzZYa().zzc7().zzH(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzZPE.zzZYf() != 15) {
            this.zzZPE.zzT(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, yValues);
        chartSeries.zzaM().zzb1().zzH(3, this.zzZPE.zzZWR());
        chartSeries.zzaB().zzW(ChartSeriesCollection.zzW(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzaw().zzW(ChartSeriesCollection.zzW(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzZ(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzZPE);
        chartSeries.setName(string);
        this.zzS(chartSeries);
        chartSeries.zzPa(this.zzZPE.zzZWV().size());
        ChartSeries chartSeries2 = chartSeries;
        chartSeries2.zzOX(chartSeries2.getIndex());
        chartSeries.zzaz().zzW(ChartSeriesCollection.zzW(dArray));
        chartSeries.zzaA().zzW(chartSeries.zzaz().zzZV2());
        this.zzZPE.zzP(chartSeries);
        return chartSeries;
    }

    private void zzS(ChartSeries chartSeries) {
        chartSeries.zzaM().zzb1().zzH(5, new zzGC());
        switch (this.zzZPE.zzZYf()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzZ(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzZ(chartSeries, 5);
                ChartSeriesCollection.zzQ(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzZ(chartSeries, 1);
                ChartSeriesCollection.zzQ(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzR(chartSeries);
            }
        }
    }

    private static void zzR(ChartSeries chartSeries) {
        zzGC zzGC2 = new zzGC();
        zzGC2.zzY(new zz8N());
        zz73 zz732 = new zz73();
        zz732.zzHF(1);
        zzGC2.zz0H().zzY(new zz5X(zz732));
        zzGC2.zz0H().zzYh(19050.0);
        chartSeries.zzaM().zzb1().zzH(5, zzGC2);
    }

    private static void zzQ(ChartSeries chartSeries) {
        zzGC zzGC2 = new zzGC();
        zzGC2.zzY(new zz8N());
        zzGC2.zz0H().zzY(new zz99());
        zzGC2.zz0H().setEndCap(0);
        zzGC2.zz0H().zzYh(19050.0);
        chartSeries.zzaM().zzb1().zzH(5, zzGC2);
    }

    private static void zzZ(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker();
        chartMarker.zzaQ().zzH(0, n);
        chartSeries.zzaM().zzb1().zzH(4, chartMarker);
    }

    private static zzFO zzW(double[] dArray) {
        int n = 0;
        zzFO zzFO2 = new zzFO(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzFO2.zzQ(new zzH4(n, d, "General"));
            }
            ++n;
        }
        zzFO2.zzLY(dArray.length);
        zzFO2.zzZOD();
        return zzFO2;
    }

    private static zzFO zzZ(zz3R[] zz3RArray) {
        int n = 0;
        zzFO zzFO2 = new zzFO(2, false);
        zz3R[] zz3RArray2 = zz3RArray;
        int n2 = zz3RArray.length;
        for (int i = 0; i < n2; ++i) {
            zz3R zz3R2 = zz3RArray2[i];
            zzFO2.zzQ(new zzH4(n++, zz3R2.zzq8(), "m/d/yyyy"));
        }
        zzFO2.zzLY(zz3RArray.length);
        zzFO2.zzZOD();
        return zzFO2;
    }

    private static zzFO zzL(String[] stringArray) {
        int n = 0;
        zzFO zzFO2 = new zzFO(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzFO2.zzQ(new zzG9(n++, string));
        }
        zzFO2.zzLY(stringArray.length);
        zzFO2.zzZOD();
        return zzFO2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZPE.zzZWV().size();
    }
}

