/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzYS;
import com.aspose.words.zz0W;
import com.aspose.words.zz6;
import com.aspose.words.zzCS;
import com.aspose.words.zzYD;
import com.aspose.words.zzYF5;
import com.aspose.words.zzZ7L;
import com.aspose.words.zzZGZ;
import com.aspose.words.zzZI3;
import com.aspose.words.zzZKQ;
import com.aspose.words.zzZKU;

public class Cell
extends CompositeNode<Node>
implements zzZGZ,
zzZKU {
    private zzYD zzZQN;
    private CellFormat zzZQM;
    private ParagraphCollection zzZQL;
    private TableCollection zzZQK;

    public Cell(DocumentBase doc) {
        this(doc, new zzYD());
    }

    Cell(DocumentBase doc, zzYD cellPr) {
        super(doc);
        this.zzZQN = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzeq() {
        return (Cell)this.zzYQO();
    }

    public Row getParentRow() {
        return (Row)this.zzYQW();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzep() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzY(this, true);
        }
        return -1;
    }

    final int zzeo() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzeo();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzZQM == null) {
            this.zzZQM = new CellFormat(this);
        }
        return this.zzZQM;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzZQL == null) {
            this.zzZQL = new ParagraphCollection(this);
        }
        return this.zzZQL;
    }

    public TableCollection getTables() {
        if (this.zzZQK == null) {
            this.zzZQK = new TableCollection(this);
        }
        return this.zzZQK;
    }

    final zzYD zzen() {
        return this.zzZQN;
    }

    final void zzZ(zzYD zzYD2) {
        this.zzZQN = zzYD2;
    }

    @Override
    final Node zzZ(boolean bl, zzZI3 zzZI32) {
        zzYD zzYD2;
        Cell cell = (Cell)super.zzZ(bl, zzZI32);
        zzYD zzYD3 = this.zzZQN;
        cell.zzZQN = zzYD2 = (zzYD)zzYD3.zzhP();
        cell.zzZQM = null;
        cell.zzZQL = null;
        cell.zzZQK = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() throws Exception {
        zzYF5.zzG(this);
    }

    @Override
    final boolean zzS(Node node) {
        return zzCS.zzk(node);
    }

    final int zzem() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzYQO();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZQN.zzQ5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzZQN.zzQ5(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzZKQ zzZKQ2 = zzYS.zzZ(object, zzZKQ.class);
        if (zzZKQ2 != null && zzZKQ2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzPE(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzYD.zzPv(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzZQN.zzN(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZQN.clear();
    }

    private Object zzPE(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzYS.zzZ((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzZ(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz0W getInsertRevision() {
        Cell cell = this;
        return cell.zzZQN.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zz0W value) {
        Cloneable cloneable = this;
        zz0W zz0W2 = value;
        cloneable = cloneable.zzZQN;
        ((zz6)cloneable).zzN(14, zz0W2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz0W getDeleteRevision() {
        Cell cell = this;
        return cell.zzZQN.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zz0W value) {
        Cloneable cloneable = this;
        zz0W zz0W2 = value;
        cloneable = cloneable.zzZQN;
        ((zz6)cloneable).zzN(12, zz0W2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ7L getMoveFromRevision() {
        Cell cell = this;
        return cell.zzZQN.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzZ7L value) {
        Cloneable cloneable = this;
        zzZ7L zzZ7L2 = value;
        cloneable = cloneable.zzZQN;
        ((zz6)cloneable).zzN(13, zzZ7L2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ7L getMoveToRevision() {
        Cell cell = this;
        return cell.zzZQN.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzZ7L value) {
        Cloneable cloneable = this;
        zzZ7L zzZ7L2 = value;
        cloneable = cloneable.zzZQN;
        ((zz6)cloneable).zzN(15, zzZ7L2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzZQN.remove(13);
        cell = this;
        cell.zzZQN.remove(15);
    }

    final zzYD zzYG(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzYD zzYD2 = new zzYD();
        this.zzZ(3120, zzYD2);
        this.zzZ(3140, zzYD2);
        this.zzZ(3110, zzYD2);
        this.zzZ(3130, zzYD2);
        this.zzZ(3090, zzYD2);
        this.zzZ(3100, zzYD2);
        this.zzZ(3070, zzYD2);
        this.zzZ(3080, zzYD2);
        if (bl && (tableStyle = zzYS.zzZ((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzY(this, zzYD2);
        }
        this.zzZQN.zzY((zz6)zzYD2);
        return zzYD2;
    }

    private void zzZ(int n, zzYD zzYD2) {
        zzYD2.zzN(n, this.fetchInheritedCellAttr(n));
    }
}

