package com.zzsn.knowbase.kafka.message;

import com.zzsn.knowbase.entity.Content;
import com.zzsn.knowbase.entity.KnowFile;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 知识消息体
 *
 * @author ShiQiangChen
 * @date 2024/1/5
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class KnowledgeMessage {

    private String id;
    private String title;
    /**
     * 来源
     */
    private String origin;
    /**
     * 发布时间
     */
    private String publishDate;
    /**
     * 审核状态
     */
    private Integer verifyStatus;
    private Integer verifyTime;
    /**
     * 审核人名字
     */
    private String verifierName;
    /**
     * 知识库id
     */
    private String knowledgeProjectId;
    private String kbKnowledgeId;
    /**
     * 类型
     */
    private String type;
    private String author;
    private String contentAll;
    private Integer importData;

    /**
     * 链接地址
     */
    private String sourceAddress;

    private List<Content> contents;

}
