package com.zzsn.knowbase.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 知识参数
 *
 * @author ShiQiangChen
 * @date 2024/1/4
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class KnowledgeParam {
    private String id;
    /**
     * 来源
     */
    private String origin;
    /**
     * 作者
     */
    private String author;
    /**
     * 发布时间
     */
    private String publishDate;
    /**
     * 审核状态
     */
    private Integer verifyStatus;
    /**
     * 审核人id
     */
    private String verifierId;
    /**
     * 审核人名字
     */
    private String verifierName;
    /**
     * 分类id
     */
    private String knowledgeProjectId;
    /**
     * 类型
     */
    private String typeIds;
    /**
     * 发布开始时间
     */
    private String startTime;
    /**
     * 发布结束时间
     */
    private String endTime;
    /**
     * 搜索信息
     */
    private String searchInfo;
    /**
     * 范围 1标题 2正文
     */
    private Integer searchScope;
    /**
     * 精确搜索
     */
    private String searchAccuracy;
    /**
     * 审核开始时间
     */
    private String verifyStartTime;
    /**
     * 审核结束时间
     */
    private String verifyEndTime;
    /**
     * 知识库id
     */
    private String kbKnowledgeId;
    private String subjectId;

    /**
     * 个人素材所属用户id
     */
    private String userId;

}
