package com.zzsn.knowbase.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;

/**
 * @Description: 附件表
 * @Author: jeecg-boot
 * @Date:   2023-01-18
 * @Version: V1.0
 */
@Data
@TableName("enclosure")
public class Enclosure implements Serializable {
    
	/**id*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id")
	private String id;
	/**name*/
	@Excel(name = "name", width = 15)
    @ApiModelProperty(value = "name")
	private String name;
	/**extensionName*/
	@Excel(name = "extensionName", width = 15)
    @ApiModelProperty(value = "extensionName")
	private String extensionName;
	/**urlPath*/
	@Excel(name = "urlPath", width = 15)
    @ApiModelProperty(value = "urlPath")
	private String urlPath;
	/**contentMd5*/
	@Excel(name = "contentMd5", width = 15)
    @ApiModelProperty(value = "contentMd5")
	private String contentMd5;
	/**createTime*/
	@Excel(name = "createTime", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createTime")
	private java.util.Date createTime;
	/**createBy*/
	@Excel(name = "createBy", width = 15)
    @ApiModelProperty(value = "createBy")
	private String createBy;
	
	@Excel(name = "fileSize", width = 15)
    @ApiModelProperty(value = "fileSize")
	private Long fileSize;

}
